package com.patzn.lims.consume.enums;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.patzn.cloud.commons.enums.IBaseEnum;
import com.patzn.lims.core.enums.JsonEnumDeserializer;

import java.io.Serializable;

/**
 * <p>
 * 采购单状态枚举
 * </p>
 *
 * @author hubin
 * @since 2017-12-23
 */
public enum PurchaseOrderEnum  {

    /**
     * 待提交
     */
    WAIT_APPROVAL(0, "待提交") , /**
     * 审批中
     */
    IN_APPROVAL(1, "审批中"),
    /**
     * 审批未通过
     */
    APPROVAL_FAILED(2, "审批未通过"),
    /**
     * 待采购
     */
    WAIT_PURCHASE(3, "待采购"),
    /**
     * 完成
     */
    FINISH(4, "完成"),
    /**
     * 审批驳回
     */
    APPROVAL_REJECT(5, "审批驳回"),
    /**
     * 采购中
     */
    PURCHASEING(6, "采购中"),
    /**
     * 待入库
     */
    STOCK_WAIT(7, "待入库"),
    /**
     * 部分入库
     */
    STOCK_PART(8, "部分入库");

    private int value;
    private String display;

    PurchaseOrderEnum(final int value, final String display) {
        this.value = value;
        this.display = display;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name();
    }

    public String getDisplay() {
        return this.display;
    }
//    /**
//     * 待审批
//     */
//    WAIT_APPROVAL(0, "待提交"),
//     /**
//     * 审批中
//     */
//    IN_APPROVAL(1, "审批中"),
//    /**
//     * 审批未通过
//     */
//    APPROVAL_FAILED(2, "审批未通过"),
//    /**
//     * 待采购
//     */
//    WAIT_PURCHASE(3, "待采购"),
//    /**
//     * 完成
//     */
//    FINISH(4, "完成"),
//    /**
//     * 审批驳回
//     */
//    APPROVAL_REJECT(5, "审批驳回"),
//    /**
//     * 采购中
//     */
//    PURCHASEING(6, "采购中"),
//    /**
//     * 待入库
//     */
//    STOCK_WAIT(7, "待入库"),
//    /**
//     * 部分入库
//     */
//    STOCK_PART(8, "部分入库");
//
//    private int value;
//    private String display;
//
//    PurchaseOrderEnum(final int value, final String display) {
//        this.value = value;
//        this.display = display;
//    }
//
//    public Serializable getValue() {
//        return this.value;
//    }
//
//    public String getName() {
//        return this.name();
//    }
//
//    public String getDisplay() {
//        return this.display;
//    }
}