package com.patzn.lims.consume.enums;

/**
 * <p>
 * 采购单关联耗材状态枚举
 * </p>
 *
 * @author hubin
 * @since 2017-12-22
 */
public enum PurchaseRelStateEnum {
    /**
     * 正常
     */
    NORMAL(0, "正常"),
    /**
     * 驳回
     */
    REJECT(1, "驳回"),
    /**
     * 调整
     */
    ADJUST(2, "调整"),
    /**
     * 结束
     */
    FINISH(3, "结束"),
    /**
     * 采购完成
     */
    END_PURCHASE(4, "采购完成"),
    /**
     * 已入库(部分入库或全部入库，点击页面结束按钮才能结束)
     */
    STOCK(5, "已入库");

    private int value;
    private String display;

    PurchaseRelStateEnum(final int value, final String display) {
        this.value = value;
        this.display = display;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name();
    }

    public String getDisplay() {
        return this.display;
    }
}