package com.patzn.lims.consume.enums;

public enum RelPurchaseEnum {
    /**
     * 采购单待提交
     */
    WAIT_ORDER(0, "采购单待提交"),
    /**
     * 采购单待审批
     */
    WAIT_ORDER_APPROVAL(1, "采购单待审批"),
    /**
     * 采购单审批中
     */
    ORDER_IN_APPROVAL(2, "采购单审批中"),
    /**
     * 审批未通过
     */
    FAILED_ORDER_APPROVAL(3, "审批未通过"),
    /**
     * 已结束
     */
    FINISH(4, "已结束");

    private final int value;
    private final String desc;

    RelPurchaseEnum(final int value, final String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static RelPurchaseEnum valueOf(int value) {
        RelPurchaseEnum[] rpe = RelPurchaseEnum.values();
        for (RelPurchaseEnum rp : rpe) {
            if (rp.value == value) {
                return rp;
            }
        }
        return null;
    }

    public int getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }
}