package com.patzn.lims.consume.enums;

/**
 * <p>
 * 库存使用记录类型枚举
 * </p>
 *
 * @author hubin
 * @since 2017-12-19
 */
public enum StockUserecordEnum {
    /**
     * 入库
     */
    IN_STOCK(0, "入库"),
    /**
     * 出库
     */
    OUT_STOCK(1, "出库"),
    /**
     * 归还
     */
    GIVE_BACK(2, "归还"),
    /**
     * 校正
     */
    CHECK(3, "校正");

    private final int value;
    private final String desc;

    StockUserecordEnum(final int value, final String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static StockUserecordEnum valueOf(int value) {
        StockUserecordEnum[] rpe = StockUserecordEnum.values();
        for (StockUserecordEnum ec : rpe) {
            if (ec.value == value) {
                return ec;
            }
        }
        return null;
    }

    public int getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }
}