package com.patzn.lims.consume.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.common.Tree;
import com.patzn.lims.consume.entity.LmsChemicalCategory;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.patzn.lims.consume.vo.LmsChemicalCategoryVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 试验耗材分类表 Mapper 接口
 * </p>
 *
 * @author wwd
 * @since 2020-03-21
 */
public interface LmsChemicalCategoryMapper extends BaseMapper<LmsChemicalCategory> {

    List<Tree> selectTree(@Param("ew") LmsChemicalCategory chemicalCategory, @Param("noCheck") boolean noCheck);

    List<LmsChemicalCategoryVO> selectPageVO(Page page, @Param("ew")LmsChemicalCategoryVO vo);

    List<LmsChemicalCategoryVO> selectPageRecursive(Page page, @Param("ew")LmsChemicalCategoryVO vo);

    List<LmsChemicalCategoryVO> selectPageRecursive( @Param("ew")LmsChemicalCategoryVO vo);

    List<LmsChemicalCategory> selectIncludeRoleId(@Param("roleId")Long roleId);
}
