package com.patzn.lims.consume.mapper;

import com.baomidou.mybatisplus.annotation.SqlParser;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.consume.dto.LmsChemicalDTO;
import com.patzn.lims.consume.entity.LmsChemical;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.patzn.lims.consume.vo.LmsChemicalVO;
import com.patzn.lims.core.web.Account;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 试验耗材表 Mapper 接口
 * </p>
 *
 * @author wwd
 * @since 2020-03-21
 */
public interface LmsChemicalMapper extends BaseMapper<LmsChemical> {

    Page<LmsChemicalVO> selectPageRecursive(Page page, @Param("vo") LmsChemicalVO vo);

    @SqlParser(filter = true)
    List<LmsChemicalDTO> selectListDto(Page page, @Param("account") Account account, @Param("dto") LmsChemicalDTO dto);

    List<LmsChemicalDTO> getAllOutStockByChemicalIds(@Param("chemicalIdList") List<Long> chemicalIdList);

    List<LmsChemicalDTO> getAllReturnStockByChemicalIds(@Param("chemicalIdList") List<Long> chemicalIdList);

    Page<LmsChemical> selectPageIncludeClassify(Page page, @Param("classifyId")Long classifyId, @Param("chemical")LmsChemical lmsChemical);

    Page<LmsChemical> selectPageExcludeClassify(Page page, @Param("account")Account account, @Param("classifyId")Long classifyId,@Param("chemical") LmsChemical lmsChemical);
}
