package com.patzn.lims.consume.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.consume.entity.LmsChemicalClassify;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 试验耗材归类表 服务类
 * </p>
 *
 * @author wwd
 * @since 2020-03-25
 */
public interface ILmsChemicalClassifyService extends IBaseService<LmsChemicalClassify> {

    Page<LmsChemicalClassify> page(Page<LmsChemicalClassify> page, LmsChemicalClassify lmsChemicalClassify);


    boolean saveRelChemical(Long classifyId, List<Long> chemicalIds);


    boolean removeRelChemical(Long classifyId, List<Long> chemicalIds);


    boolean addStockByChemicalId(Long chemicalId, BigDecimal stock, boolean add);



    List<LmsChemicalClassify> listByChemicalId(Long chemicalId);
}
