package com.patzn.lims.consume.service.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.patzn.lims.common.Tree;
import com.patzn.lims.consume.entity.LmsChemicalCategory;
import com.patzn.lims.consume.entity.LmsChemicalCategoryRole;
import com.patzn.lims.consume.mapper.LmsChemicalCategoryMapper;
import com.patzn.lims.consume.service.ILmsChemicalCategoryRoleService;
import com.patzn.lims.consume.service.ILmsChemicalCategoryService;
import com.patzn.lims.consume.vo.LmsChemicalCategoryVO;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 试验耗材分类表 服务实现类
 * </p>
 *
 * @author wwd
 * @since 2020-03-21
 */
@Service
public class LmsChemicalCategoryServiceImpl extends BaseServiceImpl<LmsChemicalCategoryMapper, LmsChemicalCategory> implements ILmsChemicalCategoryService {


   @Autowired
   private ILmsChemicalCategoryRoleService lmsChemicalCategoryRoleService;

    @Override
    public Page<LmsChemicalCategory> page(Page<LmsChemicalCategory> page, LmsChemicalCategory lmsChemicalCategory) {
        QueryWrapper<LmsChemicalCategory> wrapper = Wrappers.<LmsChemicalCategory>query(lmsChemicalCategory);
        return this.page(page, wrapper);
    }

    @Override
    public List<Tree> getTree(LmsChemicalCategory chemicalCategory) {
        return baseMapper.selectTree(chemicalCategory, false);
    }

    @Override
    public Page<LmsChemicalCategoryVO> pageVO(Page page, LmsChemicalCategoryVO vo) {
        if(StringUtils.isNotBlank(vo.getKeyword())){
            vo.setName(vo.getKeyword());
        }
        if (null != vo.getId()) {
            // 递归分页情况
            return pageRecursive(page, vo);
        }
        page.setRecords(baseMapper.selectPageVO(page, vo));
        return page;
    }

    @Override
    public List<LmsChemicalCategory> getCategoryAllTree(String name) {
        return list(Wrappers.<LmsChemicalCategory>query().select("id,pid,name")
                .like(StringUtils.isNotEmpty(name), "name", name)
                .eq("status", 1));
    }

    @Override
    public List<LmsChemicalCategory> listIncludeRoleId(Long roleId) {
        return baseMapper.selectIncludeRoleId(roleId);
    }

    private Page<LmsChemicalCategoryVO> pageRecursive(Page page, LmsChemicalCategoryVO vo) {
        return page.setRecords(baseMapper.selectPageRecursive(page, vo));
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveRoleCategory(Long roleId, Long[] categoryIds) {
        if (null == roleId){
            return false;
        }
        if (ArrayUtils.isEmpty(categoryIds)){
            return false;
        }
        //if (ArrayUtils.isNotEmpty(categoryIds)) {
        // 删除之前关联的内容
        lmsChemicalCategoryRoleService.remove(Wrappers.<LmsChemicalCategoryRole>query().eq("role_id", roleId));

         List<LmsChemicalCategoryRole> saveList=  Arrays.stream(categoryIds).map(categoryId -> {
            LmsChemicalCategoryRole ccr = new LmsChemicalCategoryRole();
            ccr.setRoleId(roleId);
            ccr.setCategoryId(categoryId);
            return ccr;
        }).collect(Collectors.toList());
         if (CollectionUtils.isNotEmpty(saveList)){
             return lmsChemicalCategoryRoleService.saveBatch(saveList);
         }
        return true;
    }

    @Override
    public List<LmsChemicalCategoryVO> listRecursive(LmsChemicalCategoryVO lmsChemicalCategoryVO) {
        return baseMapper.selectPageRecursive(lmsChemicalCategoryVO);
    }

}
