package com.patzn.lims.consume.service.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.patzn.lims.consume.entity.LmsChemicalRelClassify;
import com.patzn.lims.consume.mapper.LmsChemicalRelClassifyMapper;
import com.patzn.lims.consume.service.ILmsChemicalRelClassifyService;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 试验耗材归类表 服务实现类
 * </p>
 *
 * @author wwd
 * @since 2020-03-25
 */
@Service
public class LmsChemicalRelClassifyServiceImpl extends BaseServiceImpl<LmsChemicalRelClassifyMapper, LmsChemicalRelClassify> implements ILmsChemicalRelClassifyService {

    @Override
    public Page<LmsChemicalRelClassify> page(Page<LmsChemicalRelClassify> page, LmsChemicalRelClassify lmsChemicalRelClassify) {
        QueryWrapper<LmsChemicalRelClassify> wrapper = Wrappers.<LmsChemicalRelClassify>query(lmsChemicalRelClassify);
        return this.page(page, wrapper);
    }

    @Override
    public boolean deleteRelChemical(Long classifyId, List<Long> chemicalIds) {
        if (null == classifyId || CollectionUtils.isEmpty(chemicalIds)){
            return false;
        }
        return super.remove(Wrappers.<LmsChemicalRelClassify>query().eq("classify_id",classifyId).in("chemical_id",chemicalIds));
    }
}
