package com.patzn.lims.consume.service.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.patzn.cloud.commons.toolkit.RegexUtils;
import com.patzn.lims.consume.dto.LmsChemicalDTO;
import com.patzn.lims.consume.entity.LmsChemical;
import com.patzn.lims.consume.mapper.LmsChemicalMapper;
import com.patzn.lims.consume.service.ILmsChemicalCategoryService;
import com.patzn.lims.consume.service.ILmsChemicalService;
import com.patzn.lims.consume.vo.LmsChemicalCategoryVO;
import com.patzn.lims.consume.vo.LmsChemicalVO;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.LoginHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.sql.Wrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static java.util.stream.Collectors.toList;

/**
 * <p>
 * 试验耗材表 服务实现类
 * </p>
 *
 * @author wwd
 * @since 2020-03-21
 */
@Service
public class LmsChemicalServiceImpl extends BaseServiceImpl<LmsChemicalMapper, LmsChemical> implements ILmsChemicalService {

    @Autowired
    private ILmsChemicalCategoryService lmsChemicalCategoryService;


//    @Override
//    public Page<LmsChemical> page(Page<LmsChemical> page, LmsChemical lmsChemical) {
//        QueryWrapper<LmsChemical> wrapper = Wrappers.<LmsChemical>query(lmsChemical);
//        return this.page(page, wrapper);
//    }

    @Override
    public Page<LmsChemicalDTO> page(Page<LmsChemicalDTO> page, Account account, LmsChemicalDTO dto) {
        // 输入字母拼音查询
        if (RegexUtils.isCharacter(dto.getName())) {
            dto.setPinyin(dto.getName());
            dto.setName(null);
        }
        List<LmsChemicalDTO> result = baseMapper.selectListDto(page, account, dto);
        if (CollectionUtils.isNotEmpty(result)) {
            List<Long> chemicalIdList = result.stream().map(o -> o.getId()).collect(toList());
            List<LmsChemicalDTO> outDtos = baseMapper.getAllOutStockByChemicalIds(chemicalIdList);
            List<LmsChemicalDTO> returnDtos = baseMapper.getAllReturnStockByChemicalIds(chemicalIdList);
            List<LmsChemicalDTO> resultDtos = new ArrayList<>();
            for (LmsChemicalDTO outTemp : outDtos) {
                if (CollectionUtils.isNotEmpty(returnDtos)) {
                    for (LmsChemicalDTO returnTemp : returnDtos) {
                        if (outTemp.getId().longValue() == returnTemp.getId().longValue()) {
                            BigDecimal sunResult = outTemp.getAllOutStock().subtract(returnTemp.getAllOutStock());
                            LmsChemicalDTO resultTemp = new LmsChemicalDTO();
                            resultTemp.setId(outTemp.getId());
                            resultTemp.setAllOutStock(sunResult);
                            resultDtos.add(resultTemp);
                        }
                    }
                } else {
                    resultDtos.add(outTemp);
                }

            }
            Map<Long, BigDecimal> map = new HashMap<>();
            for (LmsChemicalDTO dtoTemp : resultDtos) {
                map.put(dtoTemp.getId(), dtoTemp.getAllOutStock());
            }
            if (null != map && map.size() != 0) {
                for (LmsChemicalDTO resultDto : result) {
                    if (null != map.get(resultDto.getId())) {
                        resultDto.setAllOutStock(map.get(resultDto.getId()));
                    }
                }
            }
        }
        return page.setRecords(result);
    }

    @Override
    public Page<LmsChemicalVO> pageVO(Page page, LmsChemicalVO vo) {
        vo.setCompanyId(LoginHelper.getAccount().getCompanyId());
        if (null != vo.getId()) {
            // 递归分页情况
            LmsChemicalCategoryVO lmsChemicalCategoryVO=  new LmsChemicalCategoryVO();
            lmsChemicalCategoryVO.setId(vo.getId());
            lmsChemicalCategoryVO.setCompanyId(vo.getCompanyId());
            List<LmsChemicalCategoryVO> list= lmsChemicalCategoryService.listRecursive(lmsChemicalCategoryVO);
            if (CollectionUtils.isEmpty(list)){
                return page;

            }
            List<Long> classIds = list.stream().map(i->{
                return  i.getId();
            }).collect(Collectors.toList());
            vo.setClassIds(classIds);

            return pageRecursive(page, vo);
        }
        return pageRecursive(page, vo);
    }



    @Override
    public Page<LmsChemical> pageIncludeClassify(Page page, Long classifyId, LmsChemical lmsChemical) {
        return baseMapper.selectPageIncludeClassify(page, classifyId, lmsChemical);
    }

    @Override
    public Page<LmsChemical> pageExcludeClassify(Page page, Account account, Long classifyId, LmsChemical lmsChemical) {
        return baseMapper.selectPageExcludeClassify(page, account, classifyId, lmsChemical);
    }

    @Override
    public List<LmsChemical> listByIdList(List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)){
            return Lists.newArrayList();
        }
        return super.list(Wrappers.<LmsChemical>query().in("id", idList));
    }

    @Override
    public boolean saveClassified(List<Long> chemicalIdList) {
        LmsChemical lmsChemical = new LmsChemical();
        lmsChemical.setClassifyed(1);
        if (CollectionUtils.isEmpty(chemicalIdList)){
            return false;
        }
        return super.update(lmsChemical,Wrappers.<LmsChemical>query().in("id", chemicalIdList));
    }


    private Page<LmsChemicalVO> pageRecursive(Page page, LmsChemicalVO vo) {

        vo.setCompanyId(LoginHelper.getAccount().getCompanyId());
        return baseMapper.selectPageRecursive(page, vo);
    }
}
