package com.patzn.lims.consume.service.impl;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.patzn.lims.common.StringHandleUtils;
import com.patzn.lims.consume.dto.LmsChemicalStockDTO;
import com.patzn.lims.consume.entity.LmsChemicalUserecord;
import com.patzn.lims.consume.enums.StockUserecordEnum;
import com.patzn.lims.consume.mapper.LmsChemicalUserecordMapper;
import com.patzn.lims.consume.service.ILmsChemicalUserecordService;
import com.patzn.lims.consume.vo.LmsChemicalUserecordVO;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.toolkit.RegexUtils;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.LoginHelper;
import com.patzn.lims.sys.entity.SysOrg;
import com.patzn.lims.sys.service.ISysOrgService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 耗材使用记录表 服务实现类
 * </p>
 *
 * @author wwd
 * @since 2020-03-24
 */
@Service
public class LmsChemicalUserecordServiceImpl extends BaseServiceImpl<LmsChemicalUserecordMapper, LmsChemicalUserecord> implements ILmsChemicalUserecordService {

    @Autowired
    private ISysOrgService sysOrgService;


    @Override
    public Page<LmsChemicalUserecord> page(Page<LmsChemicalUserecord> page, LmsChemicalUserecord lmsChemicalUserecord) {
        QueryWrapper<LmsChemicalUserecord> wrapper = Wrappers.<LmsChemicalUserecord>query(lmsChemicalUserecord);
        return this.page(page, wrapper);
    }

    @Override
    public Page<LmsChemicalUserecordVO> pageVO(Page page, LmsChemicalUserecordVO vo) {
        // 输入字母拼音查询
        if (RegexUtils.isCharacter(vo.getChemicalName())) {
            vo.setChemicalPinyin(vo.getChemicalName());
            vo.setChemicalName(null);
        }
        List<LmsChemicalUserecordVO> userecordVOList = baseMapper.selectPageVO(page, vo);
        if (CollectionUtils.isNotEmpty(userecordVOList)) {
            Set<Long> vos = new HashSet<>();
            userecordVOList.forEach(e -> {
                if (1 == e.getType() && null != e.getUid()) {
                    vos.add(e.getUid());
                }
            });
            if (!CollectionUtils.isEmpty(vos)) {
                Map<Long, String> longStringMap = new HashMap<>();
                vos.forEach(e -> {
                    List<SysOrg> list = sysOrgService.getListByUserId(e);
                    if (!CollectionUtils.isEmpty(list)) {
                        longStringMap.put(e, StringHandleUtils.join(list.stream().map(c -> c.getName()).collect(Collectors.toList())));
                    }
                });
                if (!longStringMap.isEmpty()) {
                    userecordVOList.forEach(e -> {
                        if (1 == e.getType() && null != e.getUid()) {
                            e.setOrgNames(longStringMap.get(e.getUid()));
                        }
                    });
                }
            }
        }
        return page.setRecords(userecordVOList);
    }



    @Override
    public boolean saveStockRecord(StockUserecordEnum stockUserecordEnum, LmsChemicalStockDTO dto) {
        if (null == dto.getId()
                || null == dto.getStock()
            //modify 存储过程中转化率不是非空
            //|| null == dto.getExstock()
        ) {
            PtAssert.fail("出入库记录数据异常，请联系管理员！");
        }
        LmsChemicalUserecord userecord = new LmsChemicalUserecord();
        userecord.setStockId(dto.getId());
        userecord.setChemicalId(dto.getChemicalId());
        userecord.setPrice(dto.getPrice());
        userecord.setAllstock(dto.getAllstock());
        userecord.setBatchstock(dto.getBatchStock());//获取该批次的总库存
        userecord.setBatchNum(dto.getBatchNum());
        userecord.setStorehouse(dto.getStorehouse());
        userecord.setValidDate(dto.getValidDate());
        userecord.setRealname(dto.getRealname());
        userecord.setStock(dto.getStock());
        userecord.setUnit(dto.getUnit());
        userecord.setExstock(dto.getExstock());
        userecord.setExunit(dto.getExunit());
        userecord.setDepId(dto.getDepId());
        userecord.setDepartment(dto.getDepartment());
        userecord.setRegistrant(dto.getRegistrant());
        userecord.setRegdate(dto.getRegdate());
        userecord.setReason(dto.getReason());
        userecord.setRemark(dto.getRemark());
        userecord.setType(stockUserecordEnum.getValue());
        if (StringUtils.isBlank(dto.getRealname())) {
            userecord.setRealname(LoginHelper.getAccount().getUserName());
        } else {
            userecord.setRealname(dto.getRealname());
        }
        if (null != dto.getOrderId()) {
            userecord.setOrderId(dto.getOrderId());
            if (null != dto.getUnqualifiedQuantity() && 0 != BigDecimal.ZERO.compareTo(dto.getUnqualifiedQuantity())) {
                userecord.setUnqualifiedQuantity(dto.getUnqualifiedQuantity());
            }
            userecord.setUnqualifiedReason(dto.getUnqualifiedReason());
            userecord.setCheckPersonId(dto.getCheckPersonId());
            userecord.setCheckPerson(dto.getCheckPerson());
        }
        return super.save(userecord);
    }
}
