package com.patzn.lims.consume.vo;

import com.patzn.lims.consume.entity.LmsChemicalPurchaseOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * <p>
 * 试验耗材采购 VO
 * </p>
 *
 * @author hubin
 * @since 2017-09-18
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsChemicalPurchaseOrderVO extends LmsChemicalPurchaseOrder {

    @ApiModelProperty(value = "操作开始时间")
    private String beginDate;

    @ApiModelProperty(value = "操作结束时间")
    private String endDate;

    @ApiModelProperty(value = "不合格数量")
    private BigDecimal unqualifiedQuantity;

    @ApiModelProperty(value = "供应商")
    private String supplier;

    @ApiModelProperty(value = "不合格原因")
    private String unqualifiedReason;

    @ApiModelProperty(value = "验收人")
    private String checkPerson;

}
