package com.patzn.lims.consume.vo;

import com.patzn.lims.consume.entity.LmsChemicalRelPurchase;
import com.patzn.lims.consume.enums.PurchaseRelStateEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
@Accessors(chain = true)
@ApiModel
public class LmsChemicalRelPurchaseVO extends LmsChemicalRelPurchase {

    @ApiModelProperty(value = "库存")
    private BigDecimal stock;

    @ApiModelProperty(value = "不合格数量")
    private BigDecimal unqualifiedQuantity;

    @ApiModelProperty(value = "不合格原因")
    private String unqualifiedReason;

    @ApiModelProperty(value = "验收人")
    private String checkPerson;

    @ApiModelProperty(value = "状态列表")
    private List<Integer> statusList;

    @ApiModelProperty(value = "状态汉字")
    private String stateDisplay;

    private Date beginDate;

    private Date endDate;

    private BigDecimal total;

    private Long categoryId;

    private String category;

    private String queryType;

    private Integer yearNum;

    private String year;

    private Long stockId;
}
