package com.patzn.lims.consume.vo;

import com.patzn.lims.consume.entity.LmsChemicalUserecord;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 试验耗材使用记录 VO
 * </p>
 *
 * @author hubin
 * @since 2017-12-20
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsChemicalUserecordVO extends LmsChemicalUserecord {

    @ApiModelProperty(value = "ID 集合")
    private List<Long> ids;

    @ApiModelProperty(value = "耗材分类")
    private String chemicalCategory;

    @ApiModelProperty(value = "耗材名称")
    private String chemicalName;

    @ApiModelProperty(value = "耗材规格型号")
    private String spec;

    @ApiModelProperty(value = "制造厂商")
    private String manufacturer;

    @ApiModelProperty(value = "纯度")
    private String quality;

    @ApiModelProperty(value = "耗材名称拼音首字母")
    private String chemicalPinyin;

    @ApiModelProperty(value = "耗材编号")
    private String chemicalNum;

    @ApiModelProperty(value = "操作开始时间")
    private String beginDate;

    @ApiModelProperty(value = "操作结束时间")
    private String endDate;

    @ApiModelProperty(value = "有效期开始时间")
    private String beginValidDate;

    @ApiModelProperty(value = "有效期结束时间")
    private String endValidDate;

    @ApiModelProperty(value = "查询类型")
    private String queryType;

    @ApiModelProperty(value = "年月")
    private String yearMonth;

    @ApiModelProperty(value = "年份")
    private String year;

    @ApiModelProperty(value = "查询年数")
    private String yearNum;

    @ApiModelProperty(value = "耗材金额")
    private String totalPrice;

    @ApiModelProperty(value = "操作人名称")
    private String operator;

    @ApiModelProperty(value = "供应商")
    private String supplier;

    @ApiModelProperty(value = "登记日期开始")
    private Date regdateBegin;

    @ApiModelProperty(value = "登记日期结束")
    private Date regdateEnd;

    @ApiModelProperty(value = "类型数组")
    private Integer[] typeArray;

    @ApiModelProperty(value = "部门名称")
    private String orgNames;

    @ApiModelProperty(value = "校正时间")
    private String amentDate;

    @ApiModelProperty(value = "申请人姓名")
    private String applyer;

    @ApiModelProperty(value = "耗材类别ID")
    private Long categoryId;

    @ApiModelProperty(value = "类型展示")
    private String typeName;

}
