package com.patzn.lims.drug.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.drug.entity.DrugAptitude;
import com.patzn.lims.drug.service.IDrugAptitudeService;
import com.patzn.lims.drug.vo.DrugAptitudeVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

/**
 * <p>
 * 食药资质项目表 前端控制器
 * </p>
 *
 * @author wwd
 * @since 2020-02-29
 */
@Api(tags = "食药资质项目表")
@RestController
@RequestMapping("/v1/aptitude")
public class DrugAptitudeController extends ServiceController<IDrugAptitudeService, DrugAptitude> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<IPage<DrugAptitude>> getPage(DrugAptitude drugAptitude) {
        return success(baseService.page(getPage(), drugAptitude));
	}


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-for-catalogue")
    public PtResult<IPage<DrugAptitude>> getPageForCatalogue(DrugAptitudeVO vo) {
        return success(baseService.pageForCatalogue(getPage(), vo));
    }


    @ApiOperation(value = "根据物品目录查询物品检测项目分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-catalogue-item")
    public PtResult<IPage<DrugAptitudeVO>> getPageCatalogueItem(DrugAptitudeVO vo) {
        return success(baseService.pageCatalogueItem(getPage(), vo));
    }


    @ApiOperation(value = "导入资质项目 EXCEL", notes = "导入资质项目 EXCEL 的数据内容")
    @PostMapping("/aptitude_item_import/")
    public PtResult<Boolean> importSplit(MultipartFile file) {
        return success(baseService.importAptitudeItem(file));
    }


    @ApiOperation(value = "导入资质项目 EXCEL", notes = "导入资质项目 EXCEL 的数据内容")
    @DeleteMapping("/delete/{id}")
    public PtResult<Boolean> deleteAptitude( @PathVariable("id") Long [] id) {
        return success(baseService.deleteAptitudeByIds(id));
    }
}
