package com.patzn.lims.drug.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.drug.entity.DrugCatalogueItem;
import com.patzn.lims.drug.service.IDrugCatalogueItemService;
import com.patzn.lims.drug.vo.DrugCatalogueItemVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 食药检测目录项目 前端控制器
 * </p>
 *
 * @author wwd
 * @since 2020-02-29
 */
@Api(tags = "食药检测目录项目")
@RestController
@RequestMapping("/v1/catalogue_item")
public class DrugCatalogueItemController extends ServiceController<IDrugCatalogueItemService, DrugCatalogueItem> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<IPage<DrugCatalogueItem>> getPage(DrugCatalogueItem drugCatalogueItem) {
        return success(baseService.page(getPage(), drugCatalogueItem));
	}

    @ApiOperation(value = "物品目录检测项目分页列表", notes = "物品目录检测项目分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-catalogue-item")
    public PtResult<IPage<DrugCatalogueItemVO>> getPageVO(DrugCatalogueItemVO vo) {
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVO(getPage(), vo));
    }



    @ApiOperation(value = "添加物品目录的检测项目", notes = "分页查询数据列表")
    @PostMapping("/save-catalogue-item")
    public PtResult<Boolean> saveCatalogueItem(@RequestParam("aptitudeIds") Long [] aptitudeIds,@RequestParam("catalogueId") Long catalogueId) {
        return success(baseService.saveCatalogueItem(aptitudeIds, catalogueId,getAccount()));
    }



}
