package com.patzn.lims.drug.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.google.common.collect.Lists;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.drug.dto.DrugItemRelEquipDTO;
import com.patzn.lims.drug.entity.DrugItem;
import com.patzn.lims.drug.entity.DrugItemAllocate;
import com.patzn.lims.drug.eunms.ItemStatusEnum;
import com.patzn.lims.drug.eunms.SingleJudgeEnum;
import com.patzn.lims.drug.service.IDrugItemService;
import com.patzn.lims.drug.vo.DrugItemVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 食药资质项目表 前端控制器
 * </p>
 *
 * @author wwd
 * @since 2020-02-29
 */
@Api(tags = "食药资质项目表")
@RestController
@RequestMapping("/v1/item")
public class DrugItemController extends ServiceController<IDrugItemService, DrugItem> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<IPage<DrugItem>> getPage(DrugItem drugItem) {
        return success(baseService.page(getPage(), drugItem));
	}


    @ApiOperation(value = "检测项目分页列表", notes = "检测项目分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-vo")
    public PtResult<IPage<DrugItemVO>> getPageVO(DrugItemVO vo) {
        return success(baseService.pageVO(getPage(), vo));
    }

    @ApiOperation(value = "检测项目分配分页列表", notes = "检测项目分配分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-allocate")
    public PtResult<IPage<DrugItemVO>> getPageAllocate(@RequestParam("sampleIds")Long[] sampleIds,DrugItemVO vo) {
        vo.setSampleIds(sampleIds);
        vo.setStatus(ItemStatusEnum.ALLOCATE);
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageAllocate(getPage(), vo));
    }



    @ApiOperation(value = "检测项目调度分页列表", notes = "检测项目调度分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-dispatch")
    public PtResult<IPage<DrugItemVO>> getPageDispatch(@RequestParam("sampleIds")Long[] sampleIds,DrugItemVO vo) {
        vo.setSampleIds(sampleIds);
        vo.setStatus(ItemStatusEnum.INPUT);
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageDispatch(getPage(), vo));
    }


    @ApiOperation(value = "检测项目数据录入分页列表", notes = "检测项目分配分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-input")
    public PtResult<IPage<DrugItemVO>> getPageInput(DrugItemVO vo) {
        vo.setStatus(ItemStatusEnum.INPUT);
        vo.setUid(getAccount().getUserId());
        return success(baseService.pageVOInput(getPage(), vo));
    }


    @ApiOperation(value = "检测项目数据录入历史分页列表", notes = "检测项目数据录入历史分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-input-his")
    public PtResult<IPage<DrugItemVO>> getPageInputHis(DrugItemVO vo) {
        vo.setStatusList(Lists.newArrayList(ItemStatusEnum.CHECK,ItemStatusEnum.AUDIT,ItemStatusEnum.END));
        vo.setUid(getAccount().getUserId());
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVOInput(getPage(), vo));
    }




    @ApiOperation(value = "环境检测项目数据录入分页列表", notes = "环境检测项目数据录入分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-input-env")
    public PtResult<IPage<DrugItemVO>> getPageInputEnv(DrugItemVO vo) {
        vo.setStatus(ItemStatusEnum.ENV_INPUT);
        return success(baseService.pageVO(getPage(), vo));
    }


    @ApiOperation(value = "环境检测项目数据录入历史分页列表", notes = "检测项目数据录入历史分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-input-env-his")
    public PtResult<IPage<DrugItemVO>> getPageInputEnvHis(DrugItemVO vo) {
        vo.setStatusList(Lists.newArrayList(ItemStatusEnum.ENV_CHECK,ItemStatusEnum.ENV_AUDIT,ItemStatusEnum.ENV_END));
        return success(baseService.pageVO(getPage(), vo));
    }



    @ApiOperation(value = "检测项目复核分页列表", notes = "检测项目复核分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-check")
    public PtResult<IPage<DrugItemVO>> getPageCheck(@RequestParam("sampleIds") Long[] sampleIds, DrugItemVO vo) {
        vo.setSampleIds(sampleIds);
        vo.setStatus(ItemStatusEnum.CHECK);
        return success(baseService.pageVO(getPage(), vo));
    }


    @ApiOperation(value = "检测项目复核历史分页列表", notes = "检测项目复核历史分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-check-his")
    public PtResult<IPage<DrugItemVO>> getPageCheckHis(DrugItemVO vo) {
        vo.setStatusList(Lists.newArrayList(ItemStatusEnum.AUDIT,ItemStatusEnum.END));
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVO(getPage(), vo));
    }



    @ApiOperation(value = "环境检测项目复核分页列表", notes = "环境检测项目复核分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-check-env")
    public PtResult<IPage<DrugItemVO>> getPageCheckEnv(DrugItemVO vo) {
        vo.setStatus(ItemStatusEnum.ENV_CHECK);
        return success(baseService.pageVO(getPage(), vo));
    }


    @ApiOperation(value = "环境检测项目复核历史分页列表", notes = "环境检测项目复核历史分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-check-env-his")
    public PtResult<IPage<DrugItemVO>> getPageCheckEnvHis(DrugItemVO vo) {
        vo.setStatusList(Lists.newArrayList(ItemStatusEnum.ENV_AUDIT,ItemStatusEnum.ENV_END));
        return success(baseService.pageVO(getPage(), vo));
    }






    @ApiOperation(value = "检测任务分配", notes = "检测任务分配")
    @PostMapping("/allocate-item")
    public PtResult<Boolean> allocateItem(@RequestParam("ids") Long [] ids, DrugItemAllocate allocate) {
        return success(baseService.allocateItem(ids,allocate,getAccount()));
    }


    @ApiOperation(value = "调整检测人", notes = "调整检测人")
    @PostMapping("/adjust-tester")
    public PtResult<Boolean> adjustTester(@RequestParam("ids") Long [] ids, DrugItemAllocate allocate) {
        return success(baseService.adjustTester(ids,allocate,getAccount()));
    }


    @ApiOperation(value = "手工判定检测项目", notes = "手工判定检测项目")
    @PostMapping("/hand_judge")
    public PtResult<Boolean> handJudge(@RequestParam("ids") Long [] ids, DrugItem drugItem) {
        return success(baseService.handJudge(ids,drugItem,getAccount()));
    }


    @ApiOperation(value = "数据复核提交", notes = "数据复核提交")
    @PostMapping("/submit-check")
    public PtResult<Boolean> submitCheck(@RequestParam("ids") Long [] ids) {
        return success(baseService.submitCheck(ids,getAccount()));
    }



    @ApiOperation(value = "环境数据复核提交", notes = "数据复核提交")
    @PostMapping("/submit-check-env")
    public PtResult<Boolean> submitCheckEnv(@RequestParam("ids") Long [] ids) {
        return success(baseService.submitCheckEnv(ids,getAccount()));
    }


    @ApiOperation(value = "批量填写检测值 ", notes = "数据录入批量填写检测值")
    @PostMapping("/bath-write-value/{itemIds}")
    public PtResult<Boolean> bathWriteValue(@PathVariable("itemIds") Long []  itemIds, DrugItem drugItem) {
        return success(baseService.bathWriteValue(itemIds,drugItem,getAccount()));
    }

    @ApiOperation(value = "批量确认项目 ", notes = "批量确认项目")
    @PostMapping("/bath-confirm-item")
    public PtResult<Boolean> bathConfirmItem(@RequestParam("itemIds") Long []  itemIds) {
        return success(baseService.bathConfirmItem(itemIds,getAccount()));
    }


    @ApiOperation(value = "环境监测批量确认项目 ", notes = "批量确认项目")
    @PostMapping("/bath-confirm-item-env")
    public PtResult<Boolean> bathConfirmItemEnv(@RequestParam("itemIds") Long []  itemIds) {
        return success(baseService.bathConfirmItemEnv(itemIds,getAccount()));
    }


    @ApiOperation(value = "检测项目审核分页列表", notes = "检测项目审核分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-audit")
    public PtResult<IPage<DrugItemVO>> getPageAudit(DrugItemVO vo) {
        vo.setStatus(ItemStatusEnum.AUDIT);
        return success(baseService.pageVO(getPage(), vo));
    }



    @ApiOperation(value = "检测项目审核历史分页列表", notes = "检测项目审核历史分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-audit-his")
    public PtResult<IPage<DrugItemVO>> getPageAuditHis(DrugItemVO vo) {
        vo.setStatusList(Lists.newArrayList(ItemStatusEnum.END));
        return success(baseService.pageVO(getPage(), vo));
    }



    @ApiOperation(value = "环境检测项目审核分页列表", notes = "环境检测项目审核分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-audit-env")
    public PtResult<IPage<DrugItemVO>> getPageAuditEnv(DrugItemVO vo) {
        vo.setStatus(ItemStatusEnum.ENV_AUDIT);
        return success(baseService.pageVO(getPage(), vo));
    }



    @ApiOperation(value = "环境检测项目审核历史分页列表", notes = "环境检测项目审核历史分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-audit-env-his")
    public PtResult<IPage<DrugItemVO>> getPageAuditEnvHis(DrugItemVO vo) {
        vo.setStatusList(Lists.newArrayList(ItemStatusEnum.ENV_END));
        return success(baseService.pageVO(getPage(), vo));
    }


    @ApiOperation(value = "数据审核提交", notes = "数据复核提交")
    @PostMapping("/submit-audit")
    public PtResult<Boolean> submitAudit(@RequestParam("ids") Long [] ids) {
        return success(baseService.submitAudit(ids,getAccount()));
    }


    @ApiOperation(value = "环境数据审核提交", notes = "环境数据审核提交")
    @PostMapping("/submit-audit-env")
    public PtResult<Boolean> submitAuditEnv(@RequestParam("ids") Long [] ids) {
        return success(baseService.submitAuditEnv(ids,getAccount()));
    }

    @ApiOperation(value = "数据复核驳回 ", notes = "数据复核驳回")
    @PostMapping("/back_check")
    public PtResult<Boolean> backCheck(@RequestParam("itemIds") Long []  itemIds,String remark) {
        return success(baseService.backCheck(itemIds,getAccount(),remark));
    }



    @ApiOperation(value = "数据审核驳回 ", notes = "数据复核驳回")
    @PostMapping("/back_audit")
    public PtResult<Boolean> backAudit(@RequestParam("itemIds") Long []  itemIds,String remark) {
        return success(baseService.backAudit(itemIds,getAccount(),remark));
    }




    @ApiOperation(value = "环境数据复核驳回 ", notes = "数据复核驳回")
    @PostMapping("/back_check_env")
    public PtResult<Boolean> backCheckEnv(@RequestParam("itemIds") Long []  itemIds,String remark) {
        return success(baseService.backCheckEnv(itemIds,getAccount(),remark));
    }



    @ApiOperation(value = "环境数据审核驳回 ", notes = "数据复核驳回")
    @PostMapping("/back_audit_env")
    public PtResult<Boolean> backAuditEnv(@RequestParam("itemIds") Long []  itemIds,String remark) {
        return success(baseService.backAuditEnv(itemIds,getAccount(),remark));
    }



    @ApiOperation(value = "不合格检测项目分页列表", notes = "检测项目分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-not-ok-vo")
    public PtResult<IPage<DrugItemVO>> getPageNotOkVO(DrugItemVO vo) {
        vo.setSingleJudge(SingleJudgeEnum.FAIL);
        return success(baseService.pageVO(getPage(), vo));
    }


    @ApiOperation(value = "不合格检测项目分页列表", notes = "检测项目分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-ok-vo")
    public PtResult<IPage<DrugItemVO>> getPageOkVO(DrugItemVO vo) {
        vo.setSingleJudgeNot(SingleJudgeEnum.FAIL);
        return success(baseService.pageVO(getPage(), vo));
    }


    @ApiOperation(value = "批量添加仪器设备", notes = "批量添加仪器设备")
    @PostMapping("/bath-add-equip")
    public PtResult<Boolean> bathAddEquip(@RequestBody DrugItemRelEquipDTO equipDTO) {
        return success(baseService.bathAddEquip(equipDTO));
    }


    @ApiOperation(value = "编辑修改检测项目", notes = "编辑修改检测项目")
    @PostMapping("/edit")
    public PtResult<Boolean> edit(DrugItem item) {
        return success(baseService.updateById(item));
    }
}
