package com.patzn.lims.drug.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.drug.entity.DrugSampleAnnex;
import com.patzn.lims.drug.service.IDrugSampleAnnexService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

/**
 * <p>
 * 食药单机系统-样品附件表 前端控制器
 * </p>
 *
 * @author wwd
 * @since 2020-03-09
 */
@Api(tags = "食药单机系统-样品附件表")
@RestController
@RequestMapping("/v1/sample_annex")
public class DrugSampleAnnexController extends ServiceController<IDrugSampleAnnexService, DrugSampleAnnex> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<IPage<DrugSampleAnnex>> getPage(DrugSampleAnnex drugSampleAnnex) {
        return success(baseService.page(getPage(), drugSampleAnnex));
	}


    @ApiOperation(value = "附件上传", notes = "附件上传")
    @PostMapping("/upload/{sampleId}")
    public PtResult<Boolean> upload(@PathVariable("sampleId") Long contractId, MultipartFile file) {
        return success(baseService.upload(file, contractId));
    }

    @ApiOperation(value = "下载附件", notes = "下载指定附件")
    @GetMapping("/download/{id}")
    public void downloadFile(@PathVariable("id")Long id) {
        baseService.downloadFile(id, request,response);
    }

}
