package com.patzn.lims.drug.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.google.common.collect.Lists;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.drug.dto.DrugSampleDTO;
import com.patzn.lims.drug.dto.DrugSampleReportDTO;
import com.patzn.lims.drug.entity.DrugSample;
import com.patzn.lims.drug.entity.DrugSampleOperation;
import com.patzn.lims.drug.eunms.ItemStatusEnum;
import com.patzn.lims.drug.eunms.OosStatusEnum;
import com.patzn.lims.drug.eunms.SampleStatusEnum;
import com.patzn.lims.drug.eunms.SingleJudgeEnum;
import com.patzn.lims.drug.service.IDrugSampleService;
import com.patzn.lims.drug.vo.DrugSampleOosVO;
import com.patzn.lims.drug.vo.DrugSampleVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 食药样品主表 前端控制器
 * </p>
 *
 * @author wwd
 * @since 2020-02-29
 */
@Api(tags = "食药样品主表")
@RestController
@RequestMapping("/v1/sample")
public class DrugSampleController extends ServiceController<IDrugSampleService, DrugSample> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<IPage<DrugSample>> getPage(DrugSample drugSample) {
        return success(baseService.page(getPage(), drugSample));
	}


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-material-register")
    public PtResult<IPage<DrugSampleVO>> getPageMaterial(DrugSampleVO vo) {
        vo.setCategory("来料检测");
        vo.setStatus(SampleStatusEnum.DRAFT);
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVO(getPage(), vo));
    }


    @ApiOperation(value = "环境监测登记分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-env-register")
    public PtResult<IPage<DrugSampleVO>> getPageEnvRegister(DrugSampleVO vo) {
        vo.setCategory("环境检测");
        vo.setStatus(SampleStatusEnum.DRAFT);
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVO(getPage(), vo));
    }


    @ApiOperation(value = "环境检测历史分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-env-register-his")
    public PtResult<IPage<DrugSampleVO>> getPageEnvHis(DrugSampleVO vo) {
        List<SampleStatusEnum> statusList = new ArrayList<>();
        statusList.add(SampleStatusEnum.STOP);
        statusList.add(SampleStatusEnum.ENV_TEST);
        statusList.add(SampleStatusEnum.ENV_PLAN_EXECUTE);
        statusList.add(SampleStatusEnum.ENV_PLAN_CHECK);
        statusList.add(SampleStatusEnum.ENV_REPORT_MAKE);
        statusList.add(SampleStatusEnum.ENV_REPORT_CHECK);
        statusList.add(SampleStatusEnum.ENV_REPORT_ISSUE);
        statusList.add(SampleStatusEnum.ENV_END);
        vo.setStatusList(statusList);
        vo.setCategory("环境检测");
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVO(getPage(), vo));
    }








    @ApiOperation(value = "稳定性监测登记分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-env-stable-register")
    public PtResult<IPage<DrugSampleVO>> getPageEnvStableRegister(DrugSampleVO vo) {
        vo.setCategory("稳定性检测");
        vo.setStatus(SampleStatusEnum.DRAFT);
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVO(getPage(), vo));
    }


    @ApiOperation(value = "稳定性检测历史分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-env-stable-register-his")
    public PtResult<IPage<DrugSampleVO>> getPageEnvStableHis(DrugSampleVO vo) {
        List<SampleStatusEnum> statusList = new ArrayList<>();
        statusList.add(SampleStatusEnum.STOP);
        statusList.add(SampleStatusEnum.ENV_TEST);
        statusList.add(SampleStatusEnum.ENV_PLAN_EXECUTE);
        statusList.add(SampleStatusEnum.ENV_PLAN_CHECK);
        statusList.add(SampleStatusEnum.ENV_REPORT_MAKE);
        statusList.add(SampleStatusEnum.ENV_REPORT_CHECK);
        statusList.add(SampleStatusEnum.ENV_REPORT_ISSUE);
        statusList.add(SampleStatusEnum.ENV_END);
        vo.setStatusList(statusList);
        vo.setCategory("稳定性检测");
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVO(getPage(), vo));
    }








    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-material-register-his")
    public PtResult<IPage<DrugSampleVO>> getPageMaterialHis(DrugSampleVO vo) {
        List<SampleStatusEnum> statusList = new ArrayList<>();
        statusList.add(SampleStatusEnum.STOP);
        statusList.add(SampleStatusEnum.MAKE);
        statusList.add(SampleStatusEnum.SEND);
        statusList.add(SampleStatusEnum.RECEIVE);
        statusList.add(SampleStatusEnum.TEST);
        statusList.add(SampleStatusEnum.REPORT_MAKE);
        statusList.add(SampleStatusEnum.REPORT_CHECK);
        statusList.add(SampleStatusEnum.REPORT_ISSUE);
        statusList.add(SampleStatusEnum.END);
        vo.setStatusList(statusList);
        vo.setCategory("来料检测");
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVO(getPage(), vo));
    }


    @ApiOperation(value = "产品检测样品登记分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-product-register")
    public PtResult<IPage<DrugSampleVO>> getPageProduct(DrugSampleVO vo) {
        vo.setCompanyId(getAccount().getCompanyId());
        vo.setStatus(SampleStatusEnum.DRAFT);
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVO(getPage(), vo));
    }


    @ApiOperation(value = "产品检测样品登记历史分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-product-register-his")
    public PtResult<IPage<DrugSampleVO>> getPageProductHis(DrugSampleVO vo) {
        List<SampleStatusEnum> statusList = new ArrayList<>();
        statusList.add(SampleStatusEnum.STOP);
        statusList.add(SampleStatusEnum.MAKE);
        statusList.add(SampleStatusEnum.SEND);
        statusList.add(SampleStatusEnum.RECEIVE);
        statusList.add(SampleStatusEnum.TEST);
        statusList.add(SampleStatusEnum.REPORT_MAKE);
        statusList.add(SampleStatusEnum.REPORT_CHECK);
        statusList.add(SampleStatusEnum.REPORT_ISSUE);
        statusList.add(SampleStatusEnum.END);
        vo.setStatusList(statusList);
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVO(getPage(), vo));
    }



    @ApiOperation(value = "稳定性检测样品登记分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-stable-register")
    public PtResult<IPage<DrugSampleVO>> getPageStable(DrugSampleVO vo) {
        vo.setStatus(SampleStatusEnum.DRAFT);
        vo.setCategory("稳定性检测");
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVO(getPage(), vo));
    }


    @ApiOperation(value = "产品检测样品登记历史分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-stable-register-his")
    public PtResult<IPage<DrugSampleVO>> getPageStableHis(DrugSampleVO vo) {
        List<SampleStatusEnum> statusList = new ArrayList<>();
        statusList.add(SampleStatusEnum.STOP);
        statusList.add(SampleStatusEnum.MAKE);
        statusList.add(SampleStatusEnum.SEND);
        statusList.add(SampleStatusEnum.RECEIVE);
        statusList.add(SampleStatusEnum.TEST);
        statusList.add(SampleStatusEnum.REPORT_MAKE);
        statusList.add(SampleStatusEnum.REPORT_CHECK);
        statusList.add(SampleStatusEnum.REPORT_ISSUE);
        statusList.add(SampleStatusEnum.END);
        vo.setStatusList(statusList);
        vo.setCategory("产品检测");
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVO(getPage(), vo));
    }



    @ApiOperation(value = "样品制备分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-sample-make")
    public PtResult<IPage<DrugSampleVO>> getPageSampleMake(DrugSampleVO vo) {
        vo.setStatus(SampleStatusEnum.MAKE);
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVO(getPage(), vo));
    }


    @ApiOperation(value = "样品制备历史分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-sample-make-his")
    public PtResult<IPage<DrugSampleVO>> getPageSampleMakeHis(DrugSampleVO vo) {
        List<SampleStatusEnum> statusList = new ArrayList<>();
        statusList.add(SampleStatusEnum.SEND);
        statusList.add(SampleStatusEnum.RECEIVE);
        statusList.add(SampleStatusEnum.TEST);
        statusList.add(SampleStatusEnum.REPORT_MAKE);
        statusList.add(SampleStatusEnum.REPORT_CHECK);
        statusList.add(SampleStatusEnum.REPORT_ISSUE);
        statusList.add(SampleStatusEnum.END);
        vo.setStatusList(statusList);
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVO(getPage(), vo));
    }



    @ApiOperation(value = "请检管理添加来料登记", notes = "请检管理添加来料登记")
    @PostMapping("/add-material-register")
    public PtResult<Boolean> addMaterialRegister(@RequestBody DrugSampleDTO dto) {
        dto.setDrugSampleOperation(new DrugSampleOperation());
        return success(baseService.addRegister(dto,getAccount()));
    }


    @ApiOperation(value = "请检管理添加环境监测登记", notes = "请检管理添加环境监测登记")
    @PostMapping("/add-env-register")
    public PtResult<Boolean> addEnvRegister(DrugSampleDTO dto) {
        dto.setDrugSampleOperation(new DrugSampleOperation());
        return success(baseService.addEnvRegister(dto,getAccount()));
    }


    @ApiOperation(value = "任务下发", notes = "任务下发")
    @PostMapping("/submit-register")
    public PtResult<Boolean> submitRegister(@RequestParam("ids") Long [] ids) {
        return success(baseService.submitRegister(ids,getAccount()));
    }


    @ApiOperation(value = "样品送样分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-sample-send")
    public PtResult<IPage<DrugSampleVO>> getPageSampleSend(DrugSampleVO vo) {
        vo.setStatus(SampleStatusEnum.SEND);
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVO(getPage(), vo));
    }


    @ApiOperation(value = "待检测任务样品分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-sample-wait-test")
        public PtResult<IPage<DrugSampleVO>> getPageSampleWaitTest(DrugSampleVO vo) {
        vo.setStatusList(Lists.newArrayList(
                SampleStatusEnum.MAKE,
                SampleStatusEnum.SEND,
                SampleStatusEnum.RECEIVE));
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVO(getPage(), vo));
    }



    @ApiOperation(value = "样品送样历史分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-sample-send-his")
    public PtResult<IPage<DrugSampleVO>> getPageSampleSendHis(DrugSampleVO vo) {
        List<SampleStatusEnum> statusList = new ArrayList<>();
        statusList.add(SampleStatusEnum.RECEIVE);
        statusList.add(SampleStatusEnum.TEST);
        statusList.add(SampleStatusEnum.REPORT_MAKE);
        statusList.add(SampleStatusEnum.REPORT_CHECK);
        statusList.add(SampleStatusEnum.REPORT_ISSUE);
        statusList.add(SampleStatusEnum.END);
        vo.setStatusList(statusList);
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVO(getPage(), vo));
    }


    @ApiOperation(value = "样品接收分页列表", notes = "样品接收分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-sample-receive")
    public PtResult<IPage<DrugSampleVO>> getPageSampleReceive(DrugSampleVO vo) {
        vo.setStatus(SampleStatusEnum.RECEIVE);
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVO(getPage(), vo));
    }

    @ApiOperation(value = "样品接收历史分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-sample-receive-his")
    public PtResult<IPage<DrugSampleVO>> getPageSampleReceiveHis(DrugSampleVO vo) {
        List<SampleStatusEnum> statusList = new ArrayList<>();
        statusList.add(SampleStatusEnum.TEST);
        statusList.add(SampleStatusEnum.REPORT_MAKE);
        statusList.add(SampleStatusEnum.REPORT_CHECK);
        statusList.add(SampleStatusEnum.REPORT_ISSUE);
        statusList.add(SampleStatusEnum.END);
        vo.setStatusList(statusList);
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVO(getPage(), vo));
    }



    @ApiOperation(value = "样品送样提交", notes = "样品送样提交")
    @PostMapping("/submit-send")
    public PtResult<Boolean> submitSend(@RequestParam("ids") Long [] ids) {
        return success(baseService.submitSend(ids,getAccount()));
    }


    @ApiOperation(value = "样品送样扫码提交", notes = "样品送样扫码提交")
    @PostMapping("/scan-submit-send")
    public PtResult<Boolean> scanSubmitSend(@RequestParam("sampleCode")String sampleCode) {
        return success(baseService.scanSubmit(sampleCode,0,getAccount()));
    }


    @ApiOperation(value = "样品接收提交", notes = "样品接收提交")
    @PostMapping("/submit-receive")
    public PtResult<Boolean> submitReceive(@RequestParam("ids") Long [] ids) {
        return success(baseService.submitReceive(ids,getAccount()));
    }

    @ApiOperation(value = "样品接收扫码提交", notes = "样品接收扫码提交")
    @PostMapping("/scan-submit-receive")
    public PtResult<Boolean> scanSubmitReceive(@RequestParam("sampleCode")String sampleCode) {
        return success(baseService.scanSubmit(sampleCode,1,getAccount()));
    }


    @ApiOperation(value = "检测任务分配样品分页列表", notes = "样品接收分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-sample-allocate")
    public PtResult<IPage<DrugSampleVO>> getPageSampleAllocate(DrugSampleVO vo) {
        vo.setStatus(SampleStatusEnum.TEST);
        vo.setItemStatus(ItemStatusEnum.ALLOCATE);
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVOByItemStatus(getPage(), vo));
    }


    @ApiOperation(value = "检测任务调度样品分页列表", notes = "检测任务调度样品分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-sample-dispatch")
    public PtResult<IPage<DrugSampleVO>> getPageSampleDispatch(DrugSampleVO vo) {
        vo.setStatus(SampleStatusEnum.TEST);
        vo.setItemStatus(ItemStatusEnum.INPUT);
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVOByItemStatus(getPage(), vo));
    }



    @ApiOperation(value = "检测数据录入样品分页列表", notes = "检测数据录入样品分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-sample-input")
    public PtResult<IPage<DrugSampleVO>> getPageSampleInput(DrugSampleVO vo) {
        vo.setStatus(SampleStatusEnum.TEST);
        vo.setItemStatus(ItemStatusEnum.INPUT);
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVOByItemStatus(getPage(), vo));
    }



    @ApiOperation(value = "环境检测数据录入样品分页列表", notes = "环境检测数据录入样品分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-sample-input-env")
    public PtResult<IPage<DrugSampleVO>> getPageSampleInputEnv(DrugSampleVO vo) {
        vo.setStatus(SampleStatusEnum.ENV_TEST);
        vo.setItemStatus(ItemStatusEnum.ENV_INPUT);
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVOByItemStatus(getPage(), vo));
    }



    @ApiOperation(value = "数据复核样品分页列表", notes = "样品接收分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-sample-check")
    public PtResult<IPage<DrugSampleVO>> getPageSampleCheck(DrugSampleVO vo) {
        vo.setStatus(SampleStatusEnum.TEST);
        vo.setItemStatus(ItemStatusEnum.CHECK);
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVOByItemStatus(getPage(), vo));
    }


    @ApiOperation(value = "数据审核样品分页列表", notes = "数据审核样品分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-sample-audit")
    public PtResult<IPage<DrugSampleVO>> getPageSampleAudit(DrugSampleVO vo) {
        vo.setStatus(SampleStatusEnum.TEST);
        vo.setItemStatus(ItemStatusEnum.AUDIT);
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVOByItemStatus(getPage(), vo));
    }



    @ApiOperation(value = "环境数据复核样品分页列表", notes = "环境数据复核样品分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-sample-check-env")
    public PtResult<IPage<DrugSampleVO>> getPageSampleCheckEnv(DrugSampleVO vo) {
        vo.setStatus(SampleStatusEnum.ENV_TEST);
        vo.setItemStatus(ItemStatusEnum.ENV_CHECK);
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVOByItemStatus(getPage(), vo));
    }


    @ApiOperation(value = "环境数据审核样品分页列表", notes = "环境数据审核样品分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-sample-audit-env")
    public PtResult<IPage<DrugSampleVO>> getPageSampleAuditEnv(DrugSampleVO vo) {
        vo.setStatus(SampleStatusEnum.ENV_TEST);
        vo.setItemStatus(ItemStatusEnum.ENV_AUDIT);
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVOByItemStatus(getPage(), vo));
    }



    @ApiOperation(value = "报告编制分页列表", notes = "报告编制分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-report-make")
    public PtResult<IPage<DrugSampleVO>> getPageReportMake(DrugSampleVO vo) {
        vo.setStatus(SampleStatusEnum.REPORT_MAKE);
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVOReport(getPage(), vo));
    }



    @ApiOperation(value = "报告编制历史分页列表", notes = "报告编制历史分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-report-make-his")
    public PtResult<IPage<DrugSampleVO>> getPageReportMakeHis(DrugSampleVO vo) {
        vo.setStatusList(Lists.newArrayList(SampleStatusEnum.REPORT_CHECK,SampleStatusEnum.REPORT_ISSUE,SampleStatusEnum.END));
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVOReport(getPage(), vo));
    }



    @ApiOperation(value = "报告审核分页列表", notes = "报告审核分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-report-check")
    public PtResult<IPage<DrugSampleVO>> getPageReportCheck(DrugSampleVO vo) {
        vo.setStatus(SampleStatusEnum.REPORT_CHECK);
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVO(getPage(), vo));
    }


    @ApiOperation(value = "报告审核历史分页列表", notes = "报告审核历史分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-report-check-his")
    public PtResult<IPage<DrugSampleVO>> getPageReportCheckHis(DrugSampleVO vo) {
        vo.setStatusList(Lists.newArrayList(SampleStatusEnum.REPORT_ISSUE,SampleStatusEnum.END));
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVOReport(getPage(), vo));
    }


    @ApiOperation(value = "报告签发分页列表", notes = "报告签发分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-report-issue")
    public PtResult<IPage<DrugSampleVO>> getPageReportIssue(DrugSampleVO vo) {
        vo.setStatus(SampleStatusEnum.REPORT_ISSUE);
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVO(getPage(), vo));
    }


    @ApiOperation(value = "报告签发历史分页列表", notes = "报告签发历史分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-report-issue-his")
    public PtResult<IPage<DrugSampleVO>> getPageReportIssueHis(DrugSampleVO vo) {
        vo.setStatusList(Lists.newArrayList(SampleStatusEnum.END));
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVOReport(getPage(), vo));
    }


    @ApiOperation(value = "报检编辑信息 ", notes = "报检编辑信息带入")
    @PostMapping("/get-sample-vo/{id}")
    public PtResult<DrugSampleVO> getSampleVO(@PathVariable("id") Long  id) {
        return success(baseService.getSampleVO(id));
    }


    @ApiOperation(value = "生成报告", notes = "生成报告")
    @PostMapping("/report_generate")
    public PtResult<Boolean> generateReport(@RequestBody DrugSampleReportDTO dto) {
        return success(baseService.reportGenerate(dto, getAccount(), response));
    }


    @ApiOperation(value = "报告编制提交", notes = "报告编制提交")
    @PostMapping("/submit-report-make")
    public PtResult<Boolean> submitReportMake(@RequestParam("ids") Long []ids) {
        return success(baseService.submitReportMake(ids,getAccount()));
    }

    @ApiOperation(value = "报告审核提交", notes = "报告审核提交")
    @PostMapping("/submit-report-check")
    public PtResult<Boolean> submitReportCheck(@RequestParam("ids") Long []ids) {
        return success(baseService.submitReportCheck(ids,getAccount()));
    }



    @ApiOperation(value = "报告签发提交", notes = "报告签发提交")
    @PostMapping("/submit-report-issue")
    public PtResult<Boolean> submitReportIssue(@RequestParam("ids") Long []ids) {
        return success(baseService.submitReportIssue(ids,getAccount()));
    }


    @ApiOperation(value = "报告查阅分页列表", notes = "报告查阅分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-report-consult")
    public PtResult<IPage<DrugSampleVO>> getPageReportConsult(DrugSampleVO vo) {
        vo.setStatus(SampleStatusEnum.END);
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVO(getPage(), vo));
    }



    @ApiOperation(value = "中止检测", notes = "中止检测")
    @PostMapping("/stop-test")
    public PtResult<Boolean> stopTest(@RequestParam("ids") Long [] ids) {
        return success(baseService.stopTest(ids,getAccount()));
    }



    //环境
    @ApiOperation(value = "环境监测计划提交", notes = "环境监测计划提交")
    @PostMapping("/submit-env-plan")
    public PtResult<Boolean> submitEnvPlan(@RequestParam("ids") Long [] ids) {
        return success(baseService.submitEnvPlan(ids,getAccount()));
    }






    @ApiOperation(value = "环境监测评审提交", notes = "环境监测评审提交")
    @PostMapping("/submit-env-plan-check")
    public PtResult<Boolean> submitEnvPlanCheck(@RequestParam("ids") Long [] ids) {
        return success(baseService.submitEnvPlanCheck(ids,getAccount()));
    }


    @ApiOperation(value = "环境监测评审驳回", notes = "环境监测评审驳回")
    @PostMapping("/back-env-plan-check")
    public PtResult<Boolean> backEnvPlanCheck(@RequestParam("ids") Long [] ids,@RequestParam("reason")String reason) {
        return success(baseService.backEnvPlanCheck(ids,reason,getAccount()));
    }



    @ApiOperation(value = "环境监测执行提交", notes = "环境监测执行提交")
    @PostMapping("/submit-env-execute")
    public PtResult<Boolean> submitEnvExecute(@RequestParam("ids") Long [] ids) {
        return success(baseService.submitEnvExecute(ids,getAccount()));
    }



    @ApiOperation(value = "环境监测评审分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-env-plan-check")
    public PtResult<IPage<DrugSampleVO>> getPageEnvPlanCheck(DrugSampleVO vo) {
        vo.setStatus(SampleStatusEnum.ENV_PLAN_CHECK);
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVO(getPage(), vo));
    }


    @ApiOperation(value = "环境监测计划评审分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-env-plan-check-his")
    public PtResult<IPage<DrugSampleVO>> getPageEnvPlanCheckHis(DrugSampleVO vo) {
        List<SampleStatusEnum> statusList = new ArrayList<>();
        statusList.add(SampleStatusEnum.ENV_PLAN_EXECUTE);
        statusList.add(SampleStatusEnum.ENV_TEST);
        statusList.add(SampleStatusEnum.ENV_REPORT_MAKE);
        statusList.add(SampleStatusEnum.ENV_REPORT_CHECK);
        statusList.add(SampleStatusEnum.ENV_REPORT_ISSUE);
        statusList.add(SampleStatusEnum.ENV_END);
        vo.setStatusList(statusList);
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVO(getPage(), vo));
    }



    @ApiOperation(value = "环境监测执行分页列表", notes = "环境监测执行分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-env-plan-execute")
    public PtResult<IPage<DrugSampleVO>> getPageEnvPlanExecute(DrugSampleVO vo) {
        vo.setStatus(SampleStatusEnum.ENV_PLAN_EXECUTE);
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVO(getPage(), vo));
    }


    @ApiOperation(value = "环境监测执行历史分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-env-plan-execute-his")
    public PtResult<IPage<DrugSampleVO>> getPageEnvPlanExecuteHis(DrugSampleVO vo) {
        List<SampleStatusEnum> statusList = new ArrayList<>();
        statusList.add(SampleStatusEnum.ENV_TEST);
        statusList.add(SampleStatusEnum.ENV_REPORT_MAKE);
        statusList.add(SampleStatusEnum.ENV_REPORT_CHECK);
        statusList.add(SampleStatusEnum.ENV_REPORT_ISSUE);
        statusList.add(SampleStatusEnum.ENV_END);
        vo.setStatusList(statusList);
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVO(getPage(), vo));
    }




    //环境报告编制

    @ApiOperation(value = "环境报告编制分页列表", notes = "环境报告编制分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-report-make-env")
    public PtResult<IPage<DrugSampleVO>> getPageReportMakeEnv(DrugSampleVO vo) {
        vo.setStatus(SampleStatusEnum.ENV_REPORT_MAKE);
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVOReport(getPage(), vo));
    }



    @ApiOperation(value = "环境报告编制历史分页列表", notes = "环境报告编制历史分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-report-make-env-his")
    public PtResult<IPage<DrugSampleVO>> getPageReportMakeEnvHis(DrugSampleVO vo) {
        vo.setStatusList(Lists.newArrayList(SampleStatusEnum.ENV_REPORT_CHECK,SampleStatusEnum.ENV_REPORT_ISSUE,SampleStatusEnum.ENV_END));
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVOReport(getPage(), vo));
    }



    @ApiOperation(value = "环境报告审核分页列表", notes = "环境报告审核分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-report-check-env")
    public PtResult<IPage<DrugSampleVO>> getPageReportCheckEnv(DrugSampleVO vo) {
        vo.setStatus(SampleStatusEnum.ENV_REPORT_CHECK);
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVO(getPage(), vo));
    }


    @ApiOperation(value = "环境报告审核历史分页列表", notes = "环境报告审核历史分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-report-check-env-his")
    public PtResult<IPage<DrugSampleVO>> getPageReportCheckEnvHis(DrugSampleVO vo) {
        vo.setStatusList(Lists.newArrayList(SampleStatusEnum.ENV_REPORT_ISSUE,SampleStatusEnum.ENV_END));
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVOReport(getPage(), vo));
    }


    @ApiOperation(value = "报告签发分页列表", notes = "报告签发分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-report-issue-env")
    public PtResult<IPage<DrugSampleVO>> getPageReportIssueEnv(DrugSampleVO vo) {
        vo.setStatus(SampleStatusEnum.ENV_REPORT_ISSUE);
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVO(getPage(), vo));
    }


    @ApiOperation(value = "报告签发历史分页列表", notes = "报告签发历史分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-report-issue-env-his")
    public PtResult<IPage<DrugSampleVO>> getPageReportIssueEnvHis(DrugSampleVO vo) {
        vo.setStatusList(Lists.newArrayList(SampleStatusEnum.ENV_END));
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVOReport(getPage(), vo));
    }



    @ApiOperation(value = "环境报告编制提交", notes = "报告编制提交")
    @PostMapping("/submit-report-make-env")
    public PtResult<Boolean> submitReportMakeEnv(@RequestParam("ids") Long []ids) {
        return success(baseService.submitReportMakeEnv(ids,getAccount()));
    }

    @ApiOperation(value = "环境报告审核提交", notes = "报告审核提交")
    @PostMapping("/submit-report-check-env")
    public PtResult<Boolean> submitReportCheckEnv(@RequestParam("ids") Long []ids) {
        return success(baseService.submitReportCheckEnv(ids,getAccount()));
    }



    @ApiOperation(value = "环境报告签发提交", notes = "报告签发提交")
    @PostMapping("/submit-report-issue-env")
    public PtResult<Boolean> submitReportIssueEnv(@RequestParam("ids") Long []ids) {
        return success(baseService.submitReportIssueEnv(ids,getAccount()));
    }




    @ApiOperation(value = "oos登记分页列表", notes = "环境报告编制分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-oos-register")
    public PtResult<IPage<DrugSampleOosVO>> getPageOosRegister(DrugSampleOosVO vo) {
        vo.setOosStatusEnumList(Lists.newArrayList(OosStatusEnum.REGISTER,OosStatusEnum.SUBMIT));
        vo.setStatus(SampleStatusEnum.END);
        vo.setSingleJudgeEnum(SingleJudgeEnum.FAIL);
        return success(baseService.pageOosRegister(getPage(), vo));
    }



    @ApiOperation(value = "oos登记分页列表", notes = "环境报告编制分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-oos-register-his")
    public PtResult<IPage<DrugSampleOosVO>> getPageOosRegisterHis(DrugSampleOosVO vo) {
        vo.setOosStatusEnumList(Lists.newArrayList(OosStatusEnum.CHECK,OosStatusEnum.RECHECK,OosStatusEnum.END));
        vo.setStatus(SampleStatusEnum.END);
        vo.setSingleJudgeEnum(SingleJudgeEnum.FAIL);
        return success(baseService.pageOosRegisterHis(getPage(), vo));
    }



    @ApiOperation(value = "oos待评审分页列表", notes = "oos待评审分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-oos-check")
    public PtResult<IPage<DrugSampleOosVO>> getPageOosCheck(DrugSampleOosVO vo) {
        vo.setOosStatusEnumList(Lists.newArrayList(OosStatusEnum.CHECK));
        vo.setStatus(SampleStatusEnum.END);
        vo.setSingleJudgeEnum(SingleJudgeEnum.FAIL);
        return success(baseService.pageOosRegister(getPage(), vo));
    }


    @ApiOperation(value = "oos复查评审驳回", notes = "oos复查评审驳回")
    @PostMapping("/back-oos-check")
    public PtResult<Boolean> backOosCheck(@RequestParam("ids") Long [] ids,@RequestParam("reason")String reason) {
        return success(baseService.backOosCheck(ids,reason,getAccount()));
    }



    @ApiOperation(value = "oos评审通过", notes = "oos评审通过")
    @PostMapping("/submit-oos-check")
    public PtResult<Boolean> submitOosCheck(@RequestParam("ids") Long []ids) {
        return success(baseService.submitOosCheck(ids,getAccount()));
    }


    @ApiOperation(value = "oos待执行分页列表", notes = "oos待执行分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-oos-execute")
    public PtResult<IPage<DrugSampleOosVO>> getPageOosExecute(DrugSampleOosVO vo) {
        vo.setStatus(SampleStatusEnum.WAIT_RECHECK);
        return success(baseService.pageOosExecute(getPage(), vo));
    }


    @ApiOperation(value = "oos待执行历史分页列表", notes = "oos待执行历史分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-oos-execute-his")
    public PtResult<IPage<DrugSampleOosVO>> getPageOosExecuteHis(DrugSampleOosVO vo) {
        vo.setNotStatus(SampleStatusEnum.WAIT_RECHECK);
        return success(baseService.pageOosExecute(getPage(), vo));
    }


    @ApiOperation(value = "oos执行提交", notes = "oos执行提交")
    @PostMapping("/submit-oos-execute")
    public PtResult<Boolean> submitOosExecute(@RequestParam("ids") Long []ids) {
        return success(baseService.submitOosExecute(ids,getAccount()));
    }





    @ApiOperation(value = "oos执行提交", notes = "oos执行提交")
    @PostMapping("/sample_vo/edit")
    public PtResult<Boolean> editSampleVO(@RequestBody DrugSampleDTO dto) {
        return success(baseService.editSampleVO(dto,getAccount()));
    }

}
