package com.patzn.lims.drug.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.drug.dto.DrugSampleKeepDTO;
import com.patzn.lims.drug.entity.DrugSampleKeep;
import com.patzn.lims.drug.eunms.KeepStatusEnum;
import com.patzn.lims.drug.service.IDrugSampleKeepService;
import com.patzn.lims.drug.vo.DrugSampleKeepVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 食药取样表 前端控制器
 * </p>
 *
 * @author wwd
 * @since 2020-02-29
 */
@Api(tags = "食药取样表")
@RestController
@RequestMapping("/v1/sample_keep")
public class DrugSampleKeepController extends ServiceController<IDrugSampleKeepService, DrugSampleKeep> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<IPage<DrugSampleKeep>> getPage(DrugSampleKeep drugSampleKeep) {
        return success(baseService.page(getPage(), drugSampleKeep));
	}

    @ApiOperation(value = "样品留样管理分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-sample-keep")
    public PtResult<IPage<DrugSampleKeepVO>> getPageSampleKeep(DrugSampleKeepVO drugSampleKeepVO) {
        drugSampleKeepVO.setType("留样");
        drugSampleKeepVO.setStatus(KeepStatusEnum.KEEPING);
        drugSampleKeepVO.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageSampleKeepVO(getPage(), drugSampleKeepVO));
    }



    @ApiOperation(value = "样品留样历史管理分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-sample-keep-his")
    public PtResult<IPage<DrugSampleKeepVO>> getPageSampleKeepHis(DrugSampleKeepVO drugSampleKeepVO) {
        drugSampleKeepVO.setType("留样");
        drugSampleKeepVO.setStatus(KeepStatusEnum.HANDLED);
        drugSampleKeepVO.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageSampleKeepVO(getPage(), drugSampleKeepVO));
    }



    @ApiOperation(value = "样品制备详情分页列表", notes = "样品制备详情分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-sample-make-detail")
    public PtResult<IPage<DrugSampleKeepVO>> getPageSampleMakeDetail(DrugSampleKeepVO drugSampleKeepVO) {
        drugSampleKeepVO.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageSampleKeepVO(getPage(), drugSampleKeepVO));
    }


    @ApiOperation(value = "批量制备完成", notes = "批量制备完成")
    @PostMapping("/bath_sample_make_end")
    public PtResult<Boolean> bathSampleMakeEnd(@RequestBody DrugSampleKeepDTO dto, @RequestParam("sampleId") Long sampleId ) {
        return success(baseService.bathSampleMakeEnd(dto,sampleId,getAccount()));
    }


    @ApiOperation(value = "批量处理完成", notes = "批量处理完成")
    @PostMapping("/bath_handle_end")
    public PtResult<Boolean> bathHandleEnd(@RequestParam("ids") Long [] ids,  DrugSampleKeep keep) {
        return success(baseService.bathHandleEnd(ids,keep,getAccount()));
    }


    @ApiOperation(value = "批量制备完成", notes = "批量制备完成")
    @PostMapping("/save-keep-info")
    public PtResult<Boolean> saveKeepInfo(@RequestParam("ids") Long [] ids, DrugSampleKeep keep) {
        return success(baseService.saveKeepInfo(ids,keep,getAccount()));
    }
}
