package com.patzn.lims.drug.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.drug.entity.DrugSampleOos;
import com.patzn.lims.drug.service.IDrugSampleOosService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * oos登记表 前端控制器
 * </p>
 *
 * @author wwd
 * @since 2020-03-13
 */
@Api(tags = "oos登记表")
@RestController
@RequestMapping("/v1/sample_oos")
public class DrugSampleOosController extends ServiceController<IDrugSampleOosService, DrugSampleOos> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<IPage<DrugSampleOos>> getPage(DrugSampleOos drugSampleOos) {
        return success(baseService.page(getPage(), drugSampleOos));
	}


    @ApiOperation(value = "登记oos复查处理意见", notes = "登记oos复查处理意见")
    @PostMapping("/register-suggestion")
    public PtResult<Boolean> registerSuggestion(DrugSampleOos oos) {
        return success(baseService.registerSuggestion(oos,getAccount()));
    }



    @ApiOperation(value = "oos复查登记提交", notes = "oos复查登记提交")
    @PostMapping("/submit_oos_register")
    public PtResult<Boolean> submitOosRegister(@RequestParam("ids") Long[] ids) {
        return success(baseService.submitOosRegister(ids,getAccount()));
    }

}
