package com.patzn.lims.drug.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.drug.entity.DrugSampleReport;
import com.patzn.lims.drug.service.IDrugSampleReportService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 食药单机版报告表 前端控制器
 * </p>
 *
 * @author wwd
 * @since 2020-03-10
 */
@Api(tags = "食药单机版报告表")
@RestController
@RequestMapping("/v1/sample_report")
public class DrugSampleReportController extends ServiceController<IDrugSampleReportService, DrugSampleReport> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<IPage<DrugSampleReport>> getPage(DrugSampleReport drugSampleReport) {
        return success(baseService.page(getPage(), drugSampleReport));
	}


    @ApiOperation(value = "下载报告文件", notes = "根据报检单 ID 下载报告文件")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "contractSampleId", value = "报检单 ID", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/download/{sampleId}")
    public void download(@PathVariable("sampleId") Long[] sampleId) {
        baseService.download(sampleId, response,new DrugSampleReport());
    }

}
