package com.patzn.lims.drug.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.drug.entity.DrugStandard;
import com.patzn.lims.drug.service.IDrugStandardService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * <p>
 * 食药检测依据 前端控制器
 * </p>
 *
 * @author wangweidong
 * @since 2020-02-29
 */
@Api(tags = "食药检测依据")
@RestController
@RequestMapping("/v1/standard")
public class DrugStandardController extends ServiceController<IDrugStandardService, DrugStandard> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<IPage<DrugStandard>> getPage(DrugStandard drugStandard) {
        return success(baseService.page(getPage(), drugStandard));
	}

    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list_data")
    public PtResult<List<DrugStandard>> getListData(DrugStandard drugStandard) {
        return success(baseService.listData(drugStandard));
    }

    @ApiOperation(value = "删除", notes = "删除")
    @PostMapping("/delete/{ids}")
    public PtResult<Boolean> deletedByIds(@PathVariable("ids") Long [] ids) {
        return success(baseService.remove(Wrappers.<DrugStandard>query().in("id",ids)));
    }

}
