package com.patzn.lims.drug.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.drug.entity.DrugTestCatalogue;
import com.patzn.lims.drug.service.IDrugTestCatalogueService;
import com.patzn.lims.drug.vo.DrugTestCatalogueVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 食药检测目录 前端控制器
 * </p>
 *
 * @author wwd
 * @since 2020-02-29
 */
@Api(tags = "食药检测目录")
@RestController
@RequestMapping("/v1/test_catalogue")
public class DrugTestCatalogueController extends ServiceController<IDrugTestCatalogueService, DrugTestCatalogue> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<IPage<DrugTestCatalogueVO>> getPage(DrugTestCatalogueVO drugTestCatalogue) {
        drugTestCatalogue.setTestType(0);
        return success(baseService.pageVO(getPage(), drugTestCatalogue));
	}


    @ApiOperation(value = "点位类型分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-point")
    public PtResult<IPage<DrugTestCatalogueVO>> getPagePoint(DrugTestCatalogueVO drugTestCatalogue) {
        drugTestCatalogue.setTestType(1);
        return success(baseService.pageVO(getPage(), drugTestCatalogue));
    }

}
