package com.patzn.lims.drug.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.drug.entity.DrugTestType;
import com.patzn.lims.drug.service.IDrugTestTypeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * <p>
 * 食药物料类型 前端控制器
 * </p>
 *
 * @author wwd
 * @since 2020-02-29
 */
@Api(tags = "食药物料类型")
@RestController
@RequestMapping("/v1/test_type")
public class DrugTestTypeController extends ServiceController<IDrugTestTypeService, DrugTestType> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<IPage<DrugTestType>> getPage(DrugTestType drugTestType) {
        drugTestType.setType(0);
        return success(baseService.page(getPage(), drugTestType));
	}


    @ApiOperation(value = "点位类型分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page_point")
    public PtResult<IPage<DrugTestType>> getPagePoint(DrugTestType drugTestType) {
        drugTestType.setType(1);
        return success(baseService.page(getPage(), drugTestType));
    }


    @ApiOperation(value = "A类检测类型树列表", notes = "A类查询数据列表")
    @PostMapping("/list-class")
    public PtResult<List<DrugTestType>> getClassList(DrugTestType drugTestType) {
        drugTestType.setType(0);
        return success(baseService.getClassList(drugTestType));
    }


    @ApiOperation(value = "检测类型名称", notes = "A类查询数据列表")
    @PostMapping("/list-string")
    public PtResult<List<String>> getStringList(DrugTestType drugTestType) {
        return success(baseService.getStringList(drugTestType));
    }



    @ApiOperation(value = "点位类型树列表", notes = "A类查询数据列表")
    @PostMapping("/list-point-class")
    public PtResult<List<DrugTestType>> getPointClassList(DrugTestType drugTestType) {
        drugTestType.setType(1);
        return success(baseService.getClassList(drugTestType));
    }


    @ApiOperation(value = "增加点位类型", notes = "增加点位类型")
    @PostMapping("/add-point")
    public PtResult<Boolean> addPoint(DrugTestType drugTestType) {
        drugTestType.setType(1);
        return success(baseService.save(drugTestType));
    }


}
