package com.patzn.lims.drug.entity;

import java.math.BigDecimal;
import com.patzn.lims.core.bean.BaseEntity;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 食药检测目录项目
 * </p>
 *
 * @author wwd
 * @since 2020-02-29
 */
@Data
@Accessors(chain = true)
@ApiModel
public class DrugCatalogueItem extends BaseEntity {

    @ApiModelProperty(value = "物品目录ID")
	private Long catalogueId;
    @ApiModelProperty(value = "资质ID")
	private Long aptitudeId;
    @ApiModelProperty(value = "目录描述")
	private String remark;
    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;
    @ApiModelProperty(value = "创建人ID")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;
    @ApiModelProperty(value = "最后修改人ID")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;
    @ApiModelProperty(value = "最后修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;
    @ApiModelProperty(value = "是否删除0否1是")
    @TableLogic
	private Integer deleted;
    @ApiModelProperty(value = "企业ID")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;
    @ApiModelProperty(value = "排序")
	private BigDecimal orderBy;


}
