package com.patzn.lims.drug.entity;

import java.math.BigDecimal;
import com.patzn.lims.core.bean.BaseEntity;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableField;

import com.patzn.lims.drug.eunms.ItemStatusEnum;
import com.patzn.lims.drug.eunms.SingleJudgeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 食药资质项目表
 * </p>
 *
 * @author wwd
 * @since 2020-02-29
 */
@Data
@Accessors(chain = true)
@ApiModel
public class DrugItem extends BaseEntity {

    @ApiModelProperty(value = "检测项目")
	private String name;
    @ApiModelProperty(value = "检测类别")
	private String type;
	@ApiModelProperty(value = "检测依据")
	private String code;
	@ApiModelProperty(value = "检测依据名称")
	private String standardName;
    @ApiModelProperty(value = "备注")
	private String remark;
    @ApiModelProperty(value = "标准ID")
	private Long standardId;
    @ApiModelProperty(value = "检测科室")
	private String groupName;
    @ApiModelProperty(value = "科室ID")
	private Long groupId;
    @ApiModelProperty(value = "比较符")
	private String compareSymbol;
    @ApiModelProperty(value = "限量值")
	private String limitValue;
    @ApiModelProperty(value = "单位")
	private String unit;
    @ApiModelProperty(value = "是否判定0否1是")
	private Integer judged;
    @ApiModelProperty(value = "合格范围")
	private String validValue;
    @ApiModelProperty(value = "检测值默认值")
	private String defaultValue;
    @ApiModelProperty(value = "最后修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;
    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;
    @ApiModelProperty(value = "创建人ID")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;
    @ApiModelProperty(value = "最后修改人ID")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;
    @ApiModelProperty(value = "是否删除0否1是")
    @TableLogic
	private Integer deleted;
    @ApiModelProperty(value = "企业ID")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;
    @ApiModelProperty(value = "资质ID")
	private Long aptitudeId;
    @ApiModelProperty(value = "样品ID")
	private Long sampleId;
    @ApiModelProperty(value = "排序")
	private BigDecimal orderBy;
    @ApiModelProperty(value = "检测值")
	private String testValue;
    @ApiModelProperty(value = "状态")
	private ItemStatusEnum status;
    @ApiModelProperty(value = "进度")
	private ItemStatusEnum progress;
    @ApiModelProperty(value = "单项判定")
	private SingleJudgeEnum singleJudge;
	@ApiModelProperty(value = "样品量")
	private BigDecimal sampleQuantity;


}
