package com.patzn.lims.drug.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 食药检测项目操作表
 * </p>
 *
 * @author wwd
 * @since 2020-02-29
 */
@Data
@Accessors(chain = true)
@ApiModel
public class DrugItemOperation extends BaseEntity {

    @ApiModelProperty(value = "检测项目ID")
	private Long itemId;
    @ApiModelProperty(value = "检测人")
	private String tester;
    @ApiModelProperty(value = "检测人ID")
	private Long testerId;
    @ApiModelProperty(value = "检测时间")
	private Date testTime;
    @ApiModelProperty(value = "任务分配人")
	private String assigner;
    @ApiModelProperty(value = "任务时间")
	private Date assignerTime;
    @ApiModelProperty(value = "任务分配人ID")
	private Long assignerId;
    @ApiModelProperty(value = "复核人")
	private String checker;
    @ApiModelProperty(value = "复核人ID")
	private Long checkerId;
    @ApiModelProperty(value = "复核时间")
	private Date checkerTime;
    @ApiModelProperty(value = "审核时间")
	private Date examineTime;
    @ApiModelProperty(value = "审核人")
	private String examiner;
    @ApiModelProperty(value = "审核人ID")
	private Long examineId;
    @ApiModelProperty(value = "企业ID")
    @TableField(fill = FieldFill.INSERT)
	private Long companyId;


}
