package com.patzn.lims.drug.entity;

import com.patzn.lims.core.bean.BaseEntity;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 食药检测项目操作日志表
 * </p>
 *
 * @author wwd
 * @since 2020-02-29
 */
@Data
@Accessors(chain = true)
@ApiModel
public class DrugItemRecord extends BaseEntity {

    @ApiModelProperty(value = "检测项目ID")
	private Long itemId;
    @ApiModelProperty(value = "操作原因")
	private String remark;
    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;
    @ApiModelProperty(value = "创建人ID")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;
    @ApiModelProperty(value = "最后修改人ID")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;
    @ApiModelProperty(value = "最后修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;
    @ApiModelProperty(value = "是否删除0否1是")
    @TableLogic
	private Integer deleted;
    @ApiModelProperty(value = "企业ID")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;
    @ApiModelProperty(value = "类型 0流转 1回退 2更新")
	private Integer type;
    @ApiModelProperty(value = "操作阶段")
	private String origin;
    @ApiModelProperty(value = "目标阶段")
	private String target;
    @ApiModelProperty(value = "操作人")
	@TableField(fill = FieldFill.INSERT)
	private String operator;
    @ApiModelProperty(value = "操作人ID")
	private Long operatorId;


}
