package com.patzn.lims.drug.entity;

import java.util.Date;
import com.patzn.lims.core.bean.BaseEntity;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 检测项目所用仪器表
 * </p>
 *
 * @author wwd
 * @since 2020-03-16
 */
@Data
@Accessors(chain = true)
@ApiModel
public class DrugItemRelEquip extends BaseEntity {

    @ApiModelProperty(value = "检测项目ID")
	private Long itemId;
    @ApiModelProperty(value = "仪器ID")
	private Long equipId;
    @ApiModelProperty(value = "仪器名称")
	private String equipName;
    @ApiModelProperty(value = "仪器编号")
	private String equipNum;
    @ApiModelProperty(value = "实验室编号")
	private String labNum;
    @ApiModelProperty(value = "规格型号")
	private String spec;
    @ApiModelProperty(value = "仪器品牌")
	private String brand;
    @ApiModelProperty(value = "企业ID")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;
    @ApiModelProperty(value = "是否删除")
    @TableLogic
	private Integer deleted;
    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;
    @ApiModelProperty(value = "创建人ID")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;
    @ApiModelProperty(value = "最后修改人ID")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;
    @ApiModelProperty(value = "最后修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;
    @ApiModelProperty(value = "采集类型")
	private String collectionType;
    @ApiModelProperty(value = "采集地址")
	private String collectionAddress;
	private String ipAddress;
	private String acquisitionCommand;


}
