package com.patzn.lims.drug.entity;

import java.math.BigDecimal;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.patzn.lims.core.bean.BaseEntity;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableField;

import com.patzn.lims.drug.eunms.SampleStatusEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * <p>
 * 食药样品主表
 * </p>
 *
 * @author wwd
 * @since 2020-02-29
 */
@Data
@Accessors(chain = true)
@ApiModel
public class DrugSample extends BaseEntity {

    @ApiModelProperty(value = "物料名称")
	private String name;
    @ApiModelProperty(value = "业务类型")
	private String category;
    @ApiModelProperty(value = "请检测时间")
	@JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
	private Date pcTime;
    @ApiModelProperty(value = "要求完成时间")
	@JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
	private Date aeTime;
    @ApiModelProperty(value = "请检人")
	private String pcPerson;
    @ApiModelProperty(value = "请检人ID")
	private Long pcPersonId;
    @ApiModelProperty(value = "请检部门")
	private String pcDepart;
    @ApiModelProperty(value = "机台")
	private String samplePoint;
	@ApiModelProperty(value = "班次")
	private String classBan;
    @ApiModelProperty(value = "物品编码")
	private String code;
	@ApiModelProperty(value = "样品编号")
	private String sampleCode;
    @ApiModelProperty(value = "计量单位")
	private String unit;
    @ApiModelProperty(value = "规格")
	private String spec;
    @ApiModelProperty(value = "批号")
	private String lotNum;
    @ApiModelProperty(value = "数量")
	private BigDecimal quantity;
    @ApiModelProperty(value = "质量标准")
	private String standard;
    @ApiModelProperty(value = "备注")
	private String remark;

	@ApiModelProperty(value = "报告编号")
	private String reportCode;

	@JsonSerialize(using = ToStringSerializer.class)
	@ApiModelProperty(value = "供应商ID")
	private Long supplierId;

	@ApiModelProperty(value = "供应商")
	private String supplier;

	@JsonSerialize(using = ToStringSerializer.class)
	@ApiModelProperty(value = "物品目录ID")
	private Long catalogueId;
    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;
    @ApiModelProperty(value = "创建人ID")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;
    @ApiModelProperty(value = "最后修改人ID")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;
    @ApiModelProperty(value = "最后修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;
    @ApiModelProperty(value = "是否删除0否1是")
    @TableLogic
	private Integer deleted;

    @ApiModelProperty(value = "企业ID")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

    @ApiModelProperty(value = "状态")
	private SampleStatusEnum status;

    @ApiModelProperty(value = "进度")
	private SampleStatusEnum progress;

	@ApiModelProperty(value = "被复检样品ID")
	private Long recheckId;



}
