package com.patzn.lims.drug.entity;

import java.util.Date;
import com.patzn.lims.core.bean.BaseEntity;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 食药单机系统-样品附件表
 * </p>
 *
 * @author wwd
 * @since 2020-03-09
 */
@Data
@Accessors(chain = true)
@ApiModel
public class DrugSampleAnnex extends BaseEntity {

    @ApiModelProperty(value = "样品ID")
	private Long sampleId;
    @ApiModelProperty(value = "文件名称")
	private String fileName;
    @ApiModelProperty(value = "对象key")
	private String objectKey;
    @ApiModelProperty(value = "创建者ID")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;
    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;
    @ApiModelProperty(value = "文件类型")
	private String type;
    @ApiModelProperty(value = "最后修改人ID")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;
    @ApiModelProperty(value = "最后修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;
    @ApiModelProperty(value = "是否删除0否1是")
    @TableLogic
	private Integer deleted;
    @ApiModelProperty(value = "备注")
	private String remark;
    @ApiModelProperty(value = "企业ID")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;


}
