package com.patzn.lims.drug.entity;

import java.math.BigDecimal;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.patzn.lims.core.bean.BaseEntity;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableField;

import com.patzn.lims.drug.eunms.KeepStatusEnum;
import com.patzn.lims.drug.eunms.SampleStatusEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 食药取样表
 * </p>
 *
 * @author wwd
 * @since 2020-02-29
 */
@Data
@Accessors(chain = true)
@ApiModel
public class DrugSampleKeep extends BaseEntity {

    @ApiModelProperty(value = "物品ID")
	private Long sampleId;
    @ApiModelProperty(value = "目录描述")
	private String remark;

	@ApiModelProperty(value = "单位")
	private String unit;
    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;
    @ApiModelProperty(value = "创建人ID")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;
    @ApiModelProperty(value = "最后修改人ID")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;
    @ApiModelProperty(value = "最后修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;
    @ApiModelProperty(value = "是否删除0否1是")
    @TableLogic
	private Integer deleted;
    @ApiModelProperty(value = "企业ID")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;
    @ApiModelProperty(value = "取样数量")
	private BigDecimal quantity;
    @ApiModelProperty(value = "取样容器")
	private String container;
	@ApiModelProperty(value = "制备类型")
	private String type;
    @ApiModelProperty(value = "取样时间")
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date keepTime;
    @ApiModelProperty(value = "取样人")
	private String keeper;
    @ApiModelProperty(value = "取样人ID")
	private Long keeperId;
    @ApiModelProperty(value = "保存位置")
	private String position;
    @ApiModelProperty(value = "保存期限")
	private Integer timeLimit;

	@ApiModelProperty(value = "状态")
	private KeepStatusEnum status;

	@ApiModelProperty(value = "进度")
	private KeepStatusEnum progress;

	@ApiModelProperty(value = "处理时间")
	private Date handleTime;
	@ApiModelProperty(value = "处理人")
	private String handler;
	@ApiModelProperty(value = "处理人ID")
	private Long handlerId;


}
