package com.patzn.lims.drug.entity;

import java.util.Date;
import com.patzn.lims.core.bean.BaseEntity;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableField;

import com.patzn.lims.drug.eunms.OosStatusEnum;
import com.patzn.lims.drug.eunms.SampleStatusEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 
 * </p>
 *
 * @author wwd
 * @since 2020-03-13
 */
@Data
@Accessors(chain = true)
@ApiModel
public class DrugSampleOos extends BaseEntity {

    @ApiModelProperty(value = "样品ID")
	private Long sampleId;
    @ApiModelProperty(value = "状态")
	private OosStatusEnum status;
    @ApiModelProperty(value = "进度")
	private OosStatusEnum progress;
    @ApiModelProperty(value = "不符合项描述")
	private String describable;
    @ApiModelProperty(value = "处理意见")
	private String suggestion;
    @ApiModelProperty(value = "处理人")
	private String handler;
    @ApiModelProperty(value = "处理人ID")
	private Long handlerId;
    @ApiModelProperty(value = "处理时间")
	private Date handleTime;
    @ApiModelProperty(value = "创建人ID")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;
    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;
    @ApiModelProperty(value = "最后修改人ID")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;
    @ApiModelProperty(value = "最后修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;
    @ApiModelProperty(value = "企业ID")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;
    @ApiModelProperty(value = "是否删除0否1是")
    @TableLogic
	private Integer deleted;

}
