package com.patzn.lims.drug.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 食药样品操作表
 * </p>
 *
 * @author wwd
 * @since 2020-03-04
 */
@Data
@Accessors(chain = true)
@ApiModel
public class DrugSampleOperation extends BaseEntity {

    @ApiModelProperty(value = "样品ID")
	private Long sampleId;
    @ApiModelProperty(value = "任务下达人")
	private String releaser;
    @ApiModelProperty(value = "任务下达人ID")
	private Long releaserId;
    @ApiModelProperty(value = "任务下达时间")
	private Date releaseTime;
    @ApiModelProperty(value = "样品接收人")
	private String receiver;
    @ApiModelProperty(value = "样品接收时间")
	private Date receiveTime;
    @ApiModelProperty(value = "样品接收人ID")
	private Long receiverId;
    @ApiModelProperty(value = "样品制备人")
	private String maker;
    @ApiModelProperty(value = "样品制备人ID")
	private Long makerId;
    @ApiModelProperty(value = "样品制备时间")
	private Date makeTime;

    @ApiModelProperty(value = "送样人")
    private String sender;
    @ApiModelProperty(value = "送样人ID")
    private Long senderId;
    @ApiModelProperty(value = "送样时间")
    private Date sendTime;

    @ApiModelProperty(value = "检测完成时间")
	private Date testEndTime;
    @ApiModelProperty(value = "报告编制人")
	private String reportMaker;
    @ApiModelProperty(value = "报告编制人ID")
	private Long reportMakerId;
    @ApiModelProperty(value = "报告编制时间")
	private Date reportMakeTime;
    @ApiModelProperty(value = "报告审核人")
	private String reportChecker;
    @ApiModelProperty(value = "报告审核人ID")
	private Long reportCheckerId;
    @ApiModelProperty(value = "报告审核时间")
    private Date reportCheckTime;
    @ApiModelProperty(value = "报告签发人")
	private String reportIssuer;
    @ApiModelProperty(value = "报告签发人ID")
	private Long reportIssuerId;
    @ApiModelProperty(value = "报告签发时间")
	private Date reportIssueTime;
    @ApiModelProperty(value = "企业ID")
    @TableField(fill = FieldFill.INSERT)
    private Long companyId;


}
