package com.patzn.lims.drug.entity;

import java.util.Date;
import com.patzn.lims.core.bean.BaseEntity;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 食药单机版报告表
 * </p>
 *
 * @author wwd
 * @since 2020-03-10
 */
@Data
@Accessors(chain = true)
@ApiModel
public class DrugSampleReport extends BaseEntity {

    @ApiModelProperty(value = "报告id")
	private Long sampleId;
    @ApiModelProperty(value = "版本号")
	private Integer version;
    @ApiModelProperty(value = "报告备注")
	private String remark;
    @ApiModelProperty(value = "报告地址")
	private String uri;
    @ApiModelProperty(value = "企业id")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;
    @ApiModelProperty(value = "编制人")
	private String maker;
    @ApiModelProperty(value = "编制人ID")
	private Long makeId;
    @ApiModelProperty(value = "编制时间")
	private Date makeTime;
    @ApiModelProperty(value = "报告编号")
	private String reportCode;
    @ApiModelProperty(value = "是否删除0否1是")
    @TableLogic
	private Integer deleted;
    @ApiModelProperty(value = "创建人")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;
    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;
    @ApiModelProperty(value = "最后修改人ID")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;
    @ApiModelProperty(value = "最后修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;


}
