package com.patzn.lims.drug.entity;

import com.patzn.lims.core.bean.BaseEntity;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 食药检测依据
 * </p>
 *
 * @author wangweidong
 * @since 2020-02-29
 */
@Data
@Accessors(chain = true)
@ApiModel
public class DrugStandard extends BaseEntity {

    @ApiModelProperty(value = "检测依据")
	private String code;
    @ApiModelProperty(value = "备注")
	private String remark;
    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;
    @ApiModelProperty(value = "创建人ID")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;
    @ApiModelProperty(value = "最后修改人ID")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;
    @ApiModelProperty(value = "最后修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;
    @ApiModelProperty(value = "是否删除0否1是")
    @TableLogic
	private Integer deleted;
    @ApiModelProperty(value = "检测依据名称")
	private String name;
    @ApiModelProperty(value = "发布日期")
	private Date releaseDate;
    @ApiModelProperty(value = "实施日期")
	private Date implementDate;
    @ApiModelProperty(value = "发布单位")
	private String publisher;
	@TableField(fill = FieldFill.INSERT)
    @ApiModelProperty(value = "企业ID")
	private Long companyId;


}
