package com.patzn.lims.drug.entity;

import java.math.BigDecimal;
import java.util.Date;
import com.patzn.lims.core.bean.BaseEntity;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;

/**
 * <p>
 * 检测值扩展表
 * </p>
 *
 * @author wwd
 * @since 2020-05-19
 */
@Data
@Accessors(chain = true)
@ApiModel
public class TestValueExtend extends BaseEntity {

    @ApiModelProperty(value = "缺陷")
	private String defect;
    @ApiModelProperty(value = "缺陷类别")
	private String type;
    @ApiModelProperty(value = "缺陷代码")
	private String code;
    @ApiModelProperty(value = "数量")
	private BigDecimal quantity;
    @ApiModelProperty(value = "创建人ID")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;
    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;
    @ApiModelProperty(value = "最后修改人ID")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;
    @ApiModelProperty(value = "最后修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;
    @ApiModelProperty(value = "是否删除0否1是")
    @TableLogic
	private Integer deleted;
    @ApiModelProperty(value = "检测项目ID")
	private Long itemId;

    public String toDefectsString(){
    	StringBuffer sb = new StringBuffer();
    	if (StringUtils.isNotBlank(defect)){
			sb.append("缺陷："+defect).append("，");
		}
		if (StringUtils.isNotBlank(type)){
			sb.append("类别："+type).append("，");
		}
		if (StringUtils.isNotBlank(code)){
			sb.append("代码："+code).append("，");
		}
		if (null!=quantity){
			sb.append("数量："+quantity);
		}
    	return  sb.toString();
	}
}
