package com.patzn.lims.drug.eunms;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.patzn.lims.core.enums.IBaseEnum;
import com.patzn.lims.core.enums.JsonEnumDeserializer;

import java.io.Serializable;

/**
 * <p>
 * 年度计划状态枚举
 * </p>
 *
 * @author yuanchao
 * @since 2018-06-26
 */
@JsonDeserialize(using = JsonEnumDeserializer.class)
public enum ItemStatusEnum implements IBaseEnum {
    DRAFT(10, "草稿"),
    ALLOCATE(20, "检测任务分配"),
    INPUT(30, "检测数据录入"),
    CHECK(40, "数据复核"),
    AUDIT(60, "数据审核"),

    END(100, "完成"),

    BACK_CHECK(4, "数据复核退回"),
    BACK_AUDIT(6, "数据审核退回"),



    ENV_INPUT(330, "检测数据录入"),
    ENV_CHECK(340, "数据复核"),
    ENV_AUDIT(360, "数据审核"),

    BACK_ENV_INPUT(33, "检测数据录入"),
    BACK_ENV_CHECK(34, "数据复核"),
    BACK_ENV_AUDIT(36, "数据审核"),

    ENV_END(300, "完成"),

    ;

    private int value;
    private String display;

    ItemStatusEnum(int value, String display) {
        this.value = value;
        this.display = display;
    }


    @Override
    public Serializable getValue() {
        return value;
    }

    @Override
    public String getName() {
        return name();
    }

    @Override
    public String getDisplay() {
        return display;
    }
}