package com.patzn.lims.drug.eunms;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.patzn.lims.core.enums.IBaseEnum;
import com.patzn.lims.core.enums.JsonEnumDeserializer;

import java.io.Serializable;

/**
 * <p>
 * 年度计划状态枚举
 * </p>
 *
 * @author yuanchao
 * @since 2018-06-26
 */
@JsonDeserialize(using = JsonEnumDeserializer.class)
public enum KeepStatusEnum implements IBaseEnum {
    KEEPING(0, "留样中"),
    HANDLED(30, "已处理"),
    ;

    private int value;
    private String display;

    KeepStatusEnum(int value, String display) {
        this.value = value;
        this.display = display;
    }


    @Override
    public Serializable getValue() {
        return value;
    }

    @Override
    public String getName() {
        return name();
    }

    @Override
    public String getDisplay() {
        return display;
    }
}