package com.patzn.lims.drug.eunms;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.patzn.lims.core.enums.IBaseEnum;
import com.patzn.lims.core.enums.JsonEnumDeserializer;

import java.io.Serializable;

/**
 * <p>
 * 年度计划状态枚举
 * </p>
 *
 * @author yuanchao
 * @since 2018-06-26
 */
@JsonDeserialize(using = JsonEnumDeserializer.class)
public enum OosStatusEnum implements IBaseEnum {
    REGISTER(100, "待登记"),
    SUBMIT(200, "待提交"),
    CHECK(300, "待评审"),
    BACK_CHECK(3, "方案评审退回"),
    RECHECK(400, "复查中"),
    END(500, "完成"),

    ;

    private int value;
    private String display;

    OosStatusEnum(int value, String display) {
        this.value = value;
        this.display = display;
    }


    @Override
    public Serializable getValue() {
        return value;
    }

    @Override
    public String getName() {
        return name();
    }

    @Override
    public String getDisplay() {
        return display;
    }
}