package com.patzn.lims.drug.eunms;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.patzn.lims.core.enums.IBaseEnum;
import com.patzn.lims.core.enums.JsonEnumDeserializer;

import java.io.Serializable;

/**
 * <p>
 * 年度计划状态枚举
 * </p>
 *
 * @author yuanchao
 * @since 2018-06-26
 */
@JsonDeserialize(using = JsonEnumDeserializer.class)
public enum SampleStatusEnum implements IBaseEnum {
    STOP(-10, "中止"),
    WAIT_RECHECK(-5, "待复检"),
    DRAFT(0, "草稿"),
    MAKE(10, "样品制备"),
    SEND(20, "样品送样"),
    RECEIVE(30, "样品接收"),
    TEST(40, "样品检测"),
    REPORT_MAKE(60, "报告编制"),
    REPORT_CHECK(70, "报告审核"),
    REPORT_ISSUE(80, "报告签发"),
    END(100, "完成"),





    ENV_PLAN_CHECK(1000, "计划评审"),
    ENV_PLAN_EXECUTE(1100, "计划执行"),
    ENV_TEST(1140, "样品检测"),
    ENV_REPORT_MAKE(1160, "报告编制"),
    ENV_REPORT_CHECK(1170, "报告审核"),
    ENV_REPORT_ISSUE(1180, "报告签发"),
    ENV_END(1200, "完成"),
    ENV_PLAN_CHECK_BACK(5000, "计划评审退回"),
    ;

    private int value;
    private String display;

    SampleStatusEnum(int value, String display) {
        this.value = value;
        this.display = display;
    }


    @Override
    public Serializable getValue() {
        return value;
    }

    @Override
    public String getName() {
        return name();
    }

    @Override
    public String getDisplay() {
        return display;
    }
}