package com.patzn.lims.drug.eunms;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.patzn.lims.core.enums.IBaseEnum;
import com.patzn.lims.core.enums.JsonEnumDeserializer;

import java.io.Serializable;

/**
 * <p>
 * 年度计划状态枚举
 * </p>
 *
 * @author yuanchao
 * @since 2018-06-26
 */
@JsonDeserialize(using = JsonEnumDeserializer.class)
public enum SingleJudgeEnum implements IBaseEnum {
    WAIT(0, "待判定"),
    PASS(10, "合格"),
    FAIL(20, "不合格"),
    NO_TEST(20, "不检测"),
    NO_JUDGE(20, "不判定");

    private int value;
    private String display;

    SingleJudgeEnum(int value, String display) {
        this.value = value;
        this.display = display;
    }


    @Override
    public Serializable getValue() {
        return value;
    }

    @Override
    public String getName() {
        return name();
    }

    @Override
    public String getDisplay() {
        return display;
    }
}