package com.patzn.lims.drug.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.drug.entity.DrugAptitude;
import com.patzn.lims.drug.vo.DrugAptitudeVO;
import com.patzn.lims.drug.vo.DrugCatalogueItemVO;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * <p>
 * 食药资质项目表 服务类
 * </p>
 *
 * @author wwd
 * @since 2020-02-29
 */
public interface IDrugAptitudeService extends IBaseService<DrugAptitude> {

    Page<DrugAptitude> page(Page<DrugAptitude> page, DrugAptitude drugAptitude);

    Page<DrugAptitude> pageForCatalogue(Page page, DrugAptitudeVO vo);

    Page<DrugAptitudeVO> pageCatalogueItem(Page page, DrugAptitudeVO vo);

    boolean importAptitudeItem(MultipartFile file);

    boolean deleteAptitudeByIds(Long[] id);
}
