package com.patzn.lims.drug.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.drug.entity.DrugCatalogueItem;
import com.patzn.lims.drug.vo.DrugCatalogueItemVO;

import java.util.List;

/**
 * <p>
 * 食药检测目录项目 服务类
 * </p>
 *
 * @author wwd
 * @since 2020-02-29
 */
public interface IDrugCatalogueItemService extends IBaseService<DrugCatalogueItem> {

    Page<DrugCatalogueItem> page(Page<DrugCatalogueItem> page, DrugCatalogueItem drugCatalogueItem);

    boolean saveCatalogueItem(Long[] aptitudeIds, Long catalogueId, Account account);

    Page<DrugCatalogueItemVO> pageVO(Page page, DrugCatalogueItemVO vo);

    List<DrugCatalogueItemVO> listVOByCatalogueId(Long catalogueId);
}
