package com.patzn.lims.drug.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.drug.dto.DrugItemRelEquipDTO;
import com.patzn.lims.drug.entity.DrugItem;
import com.patzn.lims.drug.entity.DrugItemAllocate;
import com.patzn.lims.drug.eunms.ItemStatusEnum;
import com.patzn.lims.drug.vo.DrugItemVO;

/**
 * <p>
 * 食药资质项目表 服务类
 * </p>
 *
 * @author wwd
 * @since 2020-02-29
 */
public interface IDrugItemService extends IBaseService<DrugItem> {

    Page<DrugItem> page(Page<DrugItem> page, DrugItem drugItem);

    Page<DrugItemVO> pageAllocate(Page<DrugItemVO>  page, DrugItemVO vo);

    boolean allocateItem(Long[] ids, DrugItemAllocate allocate, Account account);

    Page<DrugItemVO> pageVO(Page page, DrugItemVO vo);

    Page<DrugItemVO> pageVOInput(Page page, DrugItemVO vo);

    boolean bathWriteValue(Long[] itemIds, DrugItem drugItem, Account account);

    boolean bathConfirmItem(Long[] itemIds, Account account);


    boolean bathConfirmItemEnv(Long[] itemIds, Account account);

    boolean submitCheck(Long[] ids, Account account);


    boolean submitCheckEnv(Long[] ids, Account account);

    boolean submitAudit(Long[] ids, Account account);


    boolean submitAuditEnv(Long[] ids, Account account);

    boolean updateByCondition(Long[] ids, ItemStatusEnum allocate);

    boolean adjustTester(Long[] ids, DrugItemAllocate allocate, Account account);

    Page<DrugItemVO> pageDispatch(Page page, DrugItemVO vo);

    boolean handJudge(Long[] ids, DrugItem drugItem, Account account);

    boolean backCheck(Long[] itemIds, Account account, String remark);

    boolean backAudit(Long[] itemIds, Account account, String remark);


    boolean backAuditEnv(Long[] itemIds, Account account, String remark);


    boolean backCheckEnv(Long[] itemIds, Account account, String remark);

    boolean bathAddEquip(DrugItemRelEquipDTO equipDTO);
}
