package com.patzn.lims.drug.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.drug.dto.DrugSampleDTO;
import com.patzn.lims.drug.dto.DrugSampleReportDTO;
import com.patzn.lims.drug.entity.DrugSample;
import com.patzn.lims.drug.vo.DrugSampleOosVO;
import com.patzn.lims.drug.vo.DrugSampleVO;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * <p>
 * 食药样品主表 服务类
 * </p>
 *
 * @author wwd
 * @since 2020-02-29
 */
public interface IDrugSampleService extends IBaseService<DrugSample> {

    Page<DrugSample> page(Page<DrugSample> page, DrugSample drugSample);

    Page<DrugSampleVO> pageVO(Page page, DrugSampleVO vo);

    boolean addRegister(DrugSampleDTO dto, Account account);

    boolean submitRegister(Long[] ids, Account account);

    boolean submitSend(Long[] ids, Account account);

    boolean submitReceive(Long[] ids, Account account);

    Page<DrugSampleVO> pageVOByItemStatus(Page page, DrugSampleVO vo);

    DrugSampleVO getSampleVO(Long id);

    boolean reportGenerate(DrugSampleReportDTO dto, Account account, HttpServletResponse response);

    Page<DrugSampleVO> pageVOReport(Page page, DrugSampleVO vo);

    boolean submitReportMake(Long[] ids, Account account);

    List<DrugSample> getListByIds(Long[] ids);

    boolean submitReportCheck(Long[] ids, Account account);

    boolean submitReportIssue(Long[] ids, Account account);

    boolean stopTest(Long[] ids, Account account);

    boolean addEnvRegister(DrugSampleDTO dto, Account account);

    boolean submitEnvPlan(Long[] ids, Account account);

    boolean submitEnvPlanCheck(Long[] ids, Account account);

    boolean backEnvPlanCheck(Long[] ids, String reason, Account account);

    boolean submitEnvExecute(Long[] ids, Account account);

    boolean submitReportMakeEnv(Long[] ids, Account account);

    boolean submitReportCheckEnv(Long[] ids, Account account);

    boolean submitReportIssueEnv(Long[] ids, Account account);

    Page<DrugSampleOosVO> pageOosRegister(Page page, DrugSampleOosVO vo);

    boolean backOosCheck(Long[] ids, String reason, Account account);

    boolean submitOosCheck(Long[] ids, Account account);

    Page<DrugSampleOosVO> pageOosExecute(Page page, DrugSampleOosVO vo);

    boolean submitOosExecute(Long[] ids, Account account);


    Page<DrugSampleOosVO> pageOosRegisterHis(Page page, DrugSampleOosVO vo);

    boolean editSampleVO(DrugSampleDTO dto, Account account);

    boolean scanSubmit(String sampleCode, int i, Account account);
}
