package com.patzn.lims.drug.service.impl;

import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.drug.entity.DrugCatalogueItem;
import com.patzn.lims.drug.mapper.DrugCatalogueItemMapper;
import com.patzn.lims.drug.service.IDrugCatalogueItemService;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.drug.vo.DrugCatalogueItemVO;
import org.springframework.stereotype.Service;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 食药检测目录项目 服务实现类
 * </p>
 *
 * @author wwd
 * @since 2020-02-29
 */
@Service
public class DrugCatalogueItemServiceImpl extends BaseServiceImpl<DrugCatalogueItemMapper, DrugCatalogueItem> implements IDrugCatalogueItemService {

    @Override
    public Page<DrugCatalogueItem> page(Page<DrugCatalogueItem> page, DrugCatalogueItem drugCatalogueItem) {
        QueryWrapper<DrugCatalogueItem> wrapper = Wrappers.<DrugCatalogueItem>query(drugCatalogueItem);
        return this.page(page, wrapper);
    }

    @Override
    public boolean saveCatalogueItem(Long[] aptitudeIds, Long catalogueId, Account account) {
        if (ArrayUtils.isEmpty(aptitudeIds)){
            PtAssert.fail("请选择检测的项目");
        }
        if (null == catalogueId){
            PtAssert.fail("请选择物品目录");
        }
        List<DrugCatalogueItem> saveList = new ArrayList<>();
        for (Long aptitudeId:aptitudeIds) {
            DrugCatalogueItem catalogueItem = new DrugCatalogueItem();
            catalogueItem.setAptitudeId(aptitudeId);
            catalogueItem.setCatalogueId(catalogueId);
            catalogueItem.setUid(account.getUserId());
            catalogueItem.setCtime(new Date());
            catalogueItem.setCompanyId(account.getCompanyId());
            saveList.add(catalogueItem);
        }
        return saveBatch(saveList);
    }

    @Override
    public Page<DrugCatalogueItemVO> pageVO(Page page, DrugCatalogueItemVO vo) {
        return baseMapper.selectCatalogueVOList(page,vo);
    }

    @Override
    public List<DrugCatalogueItemVO> listVOByCatalogueId(Long catalogueId) {
        return baseMapper.selectVOByCatalogueId(catalogueId);
    }
}
