package com.patzn.lims.drug.service.impl;

import com.patzn.lims.core.web.Account;
import com.patzn.lims.drug.entity.DrugItemOperation;
import com.patzn.lims.drug.mapper.DrugItemOperationMapper;
import com.patzn.lims.drug.service.IDrugItemOperationService;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * <p>
 * 食药检测项目操作表 服务实现类
 * </p>
 *
 * @author wwd
 * @since 2020-02-29
 */
@Service
public class DrugItemOperationServiceImpl extends BaseServiceImpl<DrugItemOperationMapper, DrugItemOperation> implements IDrugItemOperationService {

    @Override
    public Page<DrugItemOperation> page(Page<DrugItemOperation> page, DrugItemOperation drugItemOperation) {
        QueryWrapper<DrugItemOperation> wrapper = Wrappers.<DrugItemOperation>query(drugItemOperation);
        return this.page(page, wrapper);
    }

    @Override
    public boolean writeTester(Long[] itemIds, Account account) {
        DrugItemOperation operation =new DrugItemOperation();
        operation.setTester(account.getUserName());
        operation.setTesterId(account.getUserId());
        operation.setTestTime(new Date());
        return update(operation,Wrappers.<DrugItemOperation>query().in("item_id",itemIds));
    }

    @Override
    public boolean writeChecker(Long[] itemIds, Account account) {
        DrugItemOperation operation =new DrugItemOperation();
        operation.setChecker(account.getUserName());
        operation.setCheckerId(account.getUserId());
        operation.setCheckerTime(new Date());
        return update(operation,Wrappers.<DrugItemOperation>query().in("item_id",itemIds));
    }

    @Override
    public boolean writeAuditor(Long[] itemIds, Account account) {
        DrugItemOperation operation =new DrugItemOperation();
        operation.setExaminer(account.getUserName());
        operation.setExamineId(account.getUserId());
        operation.setExamineTime(new Date());
        return update(operation,Wrappers.<DrugItemOperation>query().in("item_id",itemIds));
    }


}
