package com.patzn.lims.drug.service.impl;

import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.drug.entity.DrugItemRecord;
import com.patzn.lims.drug.eunms.ItemStatusEnum;
import com.patzn.lims.drug.mapper.DrugItemRecordMapper;
import com.patzn.lims.drug.service.IDrugItemRecordService;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 食药检测项目操作日志表 服务实现类
 * </p>
 *
 * @author wwd
 * @since 2020-02-29
 */
@Service
public class DrugItemRecordServiceImpl extends BaseServiceImpl<DrugItemRecordMapper, DrugItemRecord> implements IDrugItemRecordService {

    @Override
    public Page<DrugItemRecord> page(Page<DrugItemRecord> page, DrugItemRecord drugItemRecord) {
        QueryWrapper<DrugItemRecord> wrapper = Wrappers.<DrugItemRecord>query(drugItemRecord);
        return this.page(page, wrapper);
    }

    @Override
    public boolean record(Account account, ItemStatusEnum from, ItemStatusEnum to, Long[] ids) {
        return record(account,from,to,ids,0,"数据复核提交");
    }


    @Override
    public boolean record(Account account, ItemStatusEnum from, ItemStatusEnum to, Long[] ids,String remark) {
        return record(account,from,to,ids,0,remark);
    }

    @Override
    public boolean record(Account account, ItemStatusEnum from, ItemStatusEnum to, Long[] ids,int type,String remark) {
        if (ArrayUtils.isEmpty(ids)){
            return false;
        }
        List<DrugItemRecord> saveRecordList = new ArrayList<>();
        for (Long itemId:ids) {
            DrugItemRecord itemRecord = new DrugItemRecord();
            itemRecord.setItemId(itemId);
            itemRecord.setOperator(account.getUserName());
            itemRecord.setOperatorId(account.getUserId());
            itemRecord.setOrigin(from.getDisplay());
            itemRecord.setTarget(to.getDisplay());
            itemRecord.setType(type);
            itemRecord.setRemark(remark);
            itemRecord.setDeleted(0);
            itemRecord.setCompanyId(account.getCompanyId());
            itemRecord.setUid(account.getUserId());
            itemRecord.setCtime(new  Date());
            itemRecord.setId(IdWorker.getId());
            saveRecordList.add(itemRecord);
        }

        return saveBatch(saveRecordList);
    }
}
